/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.registration.biomes.BiomeHelper;
import twilightforest.world.registration.biomes.BiomeKeys;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<ResourceKey<Biome>, Biome> BIOMES = BiomeMaker.generateBiomes();

    private static Map<ResourceKey<Biome>, Biome> generateBiomes() {
        ImmutableMap.Builder biomes = ImmutableMap.builder();
        BiomeMaker.commonBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.mushroomBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.rareBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.swampBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.darkForestBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.snowRegionBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        BiomeMaker.highlandsBiomes((ImmutableMap.Builder<ResourceKey<Biome>, Biome>)biomes);
        return biomes.build();
    }

    private static void commonBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.twilightForestGen()).m_47592_());
        biomes.put(BiomeKeys.DENSE_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).m_48034_(21794), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseForestGen()).m_47609_(0.7f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.FIREFLY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyForestParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.fireflyForestGen()).m_47609_(0.5f).m_47611_(1.0f).m_47592_());
        biomes.put(BiomeKeys.CLEARING, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.clearingGen()).m_47595_(Biome.BiomeCategory.PLAINS).m_47609_(0.8f).m_47611_(0.4f).m_47592_());
        biomes.put(BiomeKeys.OAK_SAVANNAH, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.oakSavannaGen()).m_47595_(Biome.BiomeCategory.SAVANNA).m_47609_(0.9f).m_47611_(0.0f).m_47592_());
    }

    private static void mushroomBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.mushroomForestGen()).m_47609_(0.8f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.DENSE_MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseMushroomForestGen()).m_47609_(0.8f).m_47611_(1.0f).m_47592_());
    }

    private static void rareBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SPOOKY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48045_(12865827).m_48043_(16745729).m_48034_(16421137).m_48031_(BiomeGrassColors.SPOOKY_FOREST), BiomeMaker.spookSpawning(), BiomeMaker.spookyForestGen()).m_47609_(0.5f).m_47611_(1.0f).m_47592_());
        biomes.put(BiomeKeys.ENCHANTED_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).m_48043_(65535).m_48045_(65535).m_48031_(BiomeGrassColors.ENCHANTED_FOREST), BiomeMaker.defaultMobSpawning(), BiomeMaker.enchantedForestGen()).m_47597_(Biome.Precipitation.NONE).m_47592_());
        biomes.put(BiomeKeys.STREAM, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(false)).m_47595_(Biome.BiomeCategory.RIVER).m_47609_(0.5f).m_47611_(0.1f).m_47592_());
        biomes.put(BiomeKeys.LAKE, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(true)).m_47595_(Biome.BiomeCategory.OCEAN).m_47609_(0.66f).m_47611_(1.0f).m_47592_());
    }

    private static void swampBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48045_(6056270).m_48043_(4809015).m_48034_(14745518).m_48031_(BiomeGrassColors.SWAMP), BiomeMaker.swampSpawning(), BiomeMaker.swampGen()).m_47595_(Biome.BiomeCategory.SWAMP).m_47609_(0.8f).m_47611_(0.9f).m_47592_());
        biomes.put(BiomeKeys.FIRE_SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.whiteAshParticles(BiomeMaker.defaultAmbientBuilder().m_48045_(5713443).m_48043_(6563343).m_48034_(0x6C2C2C)), new MobSpawnSettings.Builder(), BiomeMaker.fireSwampGen()).m_47595_(Biome.BiomeCategory.SWAMP).m_47597_(Biome.Precipitation.NONE).m_47609_(1.0f).m_47611_(0.4f).m_47592_());
    }

    private static void darkForestBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.DARK_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48045_(4941652).m_48043_(3890751).m_48031_(BiomeGrassColors.DARK_FOREST), BiomeMaker.darkForestSpawning(), BiomeMaker.darkForestGen()).m_47609_(0.7f).m_47611_(0.8f).m_47592_());
        biomes.put(BiomeKeys.DARK_FOREST_CENTER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().m_48045_(6714688).m_48043_(16351774).m_48031_(BiomeGrassColors.DARK_FOREST_CENTER), new MobSpawnSettings.Builder(), BiomeMaker.darkForestCenterGen()).m_47592_());
    }

    private static void snowRegionBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.SNOWY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.snowForestSpawning(), BiomeMaker.snowyForestGen()).m_47597_(Biome.Precipitation.SNOW).m_47609_(0.09f).m_47611_(0.9f).m_47592_());
        biomes.put(BiomeKeys.GLACIER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.penguinSpawning(), BiomeMaker.glacierGen()).m_47595_(Biome.BiomeCategory.ICY).m_47609_(0.8f).m_47611_(0.1f).m_47597_(Biome.Precipitation.SNOW).m_47592_());
    }

    private static void highlandsBiomes(ImmutableMap.Builder<ResourceKey<Biome>, Biome> biomes) {
        biomes.put(BiomeKeys.HIGHLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.highlandsGen()).m_47595_(Biome.BiomeCategory.MESA).m_47609_(0.4f).m_47611_(0.7f).m_47592_());
        biomes.put(BiomeKeys.THORNLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), new MobSpawnSettings.Builder(), BiomeMaker.thornlandsGen()).m_47595_(Biome.BiomeCategory.NONE).m_47609_(0.3f).m_47611_(0.2f).m_47592_());
        biomes.put(BiomeKeys.FINAL_PLATEAU, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.ravenSpawning(), BiomeMaker.plateauGen()).m_47595_(Biome.BiomeCategory.MESA).m_47609_(1.0f).m_47611_(0.2f).m_47592_());
    }
}

