/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholdsCommon;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterstrongholds.world.ArmorStandChances;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ArmorStandProcessor
extends StructureProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final Codec<ArmorStandProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.f_74685_.m_128461_("id").equals("minecraft:armor_stand")) {
            String helmet;
            ListTag armorItems = globalEntityInfo.f_74685_.m_128437_("ArmorItems", 10);
            Random random = structurePlaceSettings.m_74399_(globalEntityInfo.f_74684_);
            try {
                helmet = ((CompoundTag)armorItems.get(3)).m_128423_("id").toString();
            }
            catch (Exception e) {
                BetterStrongholdsCommon.LOGGER.info("Unable to randomize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.f_74684_);
                return globalEntityInfo;
            }
            boolean isRare = helmet.equals("\"minecraft:diamond_helmet\"");
            CompoundTag newNBT = globalEntityInfo.f_74685_.m_6426_();
            String bootsString = isRare ? Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getRareBoots(random)).toString() : Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getCommonBoots(random)).toString();
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(0)).m_128359_("id", bootsString);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(0)).m_128344_("Count", (byte)1);
            CompoundTag bootsTagNBT = new CompoundTag();
            bootsTagNBT.m_128405_("Damage", 0);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(0)).m_128365_("tag", (Tag)bootsTagNBT);
            String leggingsString = isRare ? Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getRareLeggings(random)).toString() : Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getCommonLeggings(random)).toString();
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(1)).m_128359_("id", leggingsString);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(1)).m_128344_("Count", (byte)1);
            CompoundTag leggingsTagNBT = new CompoundTag();
            leggingsTagNBT.m_128405_("Damage", 0);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(1)).m_128365_("tag", (Tag)leggingsTagNBT);
            String chesplateString = isRare ? Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getRareChestplate(random)).toString() : Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getCommonChestplate(random)).toString();
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(2)).m_128359_("id", chesplateString);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(2)).m_128344_("Count", (byte)1);
            CompoundTag chestplateTagNBT = new CompoundTag();
            chestplateTagNBT.m_128405_("Damage", 0);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(2)).m_128365_("tag", (Tag)chestplateTagNBT);
            String helmetString = isRare ? Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getRareHelmet(random)).toString() : Registry.f_122827_.m_7981_((Object)ArmorStandChances.get().getCommonHelmet(random)).toString();
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(3)).m_128359_("id", helmetString);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(3)).m_128344_("Count", (byte)1);
            CompoundTag helmetTagNBT = new CompoundTag();
            helmetTagNBT.m_128405_("Damage", 0);
            ((CompoundTag)newNBT.m_128437_("ArmorItems", 10).get(3)).m_128365_("tag", (Tag)helmetTagNBT);
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.f_74683_, globalEntityInfo.f_74684_, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorModule.ARMORSTAND_PROCESSOR;
    }
}

