/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBRanksIntegration;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public interface FTBChunksWorldConfig {
    public static final LevelResource CONFIG_FILE_PATH = new LevelResource("serverconfig/ftbchunks.snbt");
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbchunks-world");
    public static final EnumValue<ProtectionOverride> FAKE_PLAYERS = (EnumValue)CONFIG.getEnum("fake_players", NameMap.of((Object)((Object)ProtectionOverride.CHECK), (Object[])ProtectionOverride.values()).create()).comment(new String[]{"Override to disable/enable fake players like miners and auto-clickers globally. Default will check this setting for each team"});
    public static final IntValue MAX_CLAIMED_CHUNKS = (IntValue)CONFIG.getInt("max_claimed_chunks", 500).comment(new String[]{"Max claimed chunks.", "You can override this with FTB Ranks 'ftbchunks.max_claimed' permission"});
    public static final IntValue MAX_FORCE_LOADED_CHUNKS = (IntValue)CONFIG.getInt("max_force_loaded_chunks", 25).comment(new String[]{"Max force loaded chunks.", "You can override this with FTB Ranks 'ftbchunks.max_force_loaded' permission"});
    public static final BooleanValue CHUNK_LOAD_OFFLINE = (BooleanValue)CONFIG.getBoolean("chunk_load_offline", true).comment(new String[]{"Allow players to force-load chunks while they are offline. This may not take effect until each player re-logs in server, for immediate effect use 'force_load_mode'"});
    public static final EnumValue<ForceLoadMode> FORCE_LOAD_MODE = (EnumValue)CONFIG.getEnum("force_load_mode", ForceLoadMode.NAME_MAP).comment(new String[]{"Control how force-loaded chunks work"});
    public static final BooleanValue DISABLE_PROTECTION = (BooleanValue)CONFIG.getBoolean("disable_protection", false).comment(new String[]{"Disables all land protection. Useful for private servers where everyone is trusted and claims are only used for forceloading"});
    public static final EnumValue<AllyMode> ALLY_MODE = (EnumValue)CONFIG.getEnum("ally_mode", AllyMode.NAME_MAP).comment(new String[]{"Forced modes won't let players change their ally settings"});
    public static final StringListValue CLAIM_DIMENSION_BLACKLIST = (StringListValue)CONFIG.getStringList("claim_dimension_blacklist", Collections.emptyList()).comment(new String[]{"Blacklist for dimensions where chunks can't be claimed. Add \"minecraft:the_end\" to this list if you want to disable chunk claiming in The End"});
    public static final BooleanValue NO_WILDERNESS = (BooleanValue)CONFIG.getBoolean("no_wilderness", false).comment(new String[]{"Requires you to claim chunks in order to edit and interact with blocks"});
    public static final BooleanValue FORCE_DISABLE_MINIMAP = (BooleanValue)CONFIG.getBoolean("force_disable_minimap", false).comment(new String[]{"Minimap for clients connecting to this server will be disabled"});
    public static final Set<ResourceKey<Level>> CLAIM_DIMENSION_BLACKLIST_SET = new HashSet<ResourceKey<Level>>();

    public static int getMaxClaimedChunks(FTBChunksTeamData playerData, ServerPlayer player) {
        if (FTBChunks.ranksMod && player != null) {
            return FTBRanksIntegration.getMaxClaimedChunks(player, (Integer)MAX_CLAIMED_CHUNKS.get()) + playerData.getExtraClaimChunks();
        }
        return (Integer)MAX_CLAIMED_CHUNKS.get() + playerData.getExtraClaimChunks();
    }

    public static int getMaxForceLoadedChunks(FTBChunksTeamData playerData, ServerPlayer player) {
        if (FTBChunks.ranksMod && player != null) {
            return FTBRanksIntegration.getMaxForceLoadedChunks(player, (Integer)MAX_FORCE_LOADED_CHUNKS.get()) + playerData.getExtraForceLoadChunks();
        }
        return (Integer)MAX_FORCE_LOADED_CHUNKS.get() + playerData.getExtraForceLoadChunks();
    }

    public static boolean getChunkLoadOffline(ServerPlayer player) {
        if (FTBChunks.ranksMod && player != null) {
            return FTBRanksIntegration.getChunkLoadOffline(player, (Boolean)CHUNK_LOAD_OFFLINE.get());
        }
        return (Boolean)CHUNK_LOAD_OFFLINE.get();
    }

    public static boolean noWilderness(ServerPlayer player) {
        if (FTBChunks.ranksMod && player != null) {
            return FTBRanksIntegration.getNoWilderness(player, (Boolean)NO_WILDERNESS.get());
        }
        return (Boolean)NO_WILDERNESS.get();
    }
}

