/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class MapChunk {
    public static final int VERSION = 4;
    public final MapRegion region;
    public final XZ pos;
    public long modified;
    public int version;
    public ClientTeam team;
    public Date claimedDate;
    public Date forceLoadedDate;

    public MapChunk(MapRegion r, XZ p) {
        this.region = r;
        this.pos = p;
        this.modified = 0L;
        this.version = 0;
        this.team = null;
        this.claimedDate = null;
        this.forceLoadedDate = null;
    }

    @Nullable
    public ClientTeam getTeam() {
        if (this.team != null && this.team.invalid) {
            this.team = this.team.manager.getTeam(this.team.getId());
        }
        return this.team;
    }

    public boolean connects(MapChunk chunk) {
        return Objects.equals(this.getTeam(), chunk.getTeam());
    }

    public XZ getActualPos() {
        return XZ.of((int)((this.region.pos.x << 5) + this.pos.x), (int)((this.region.pos.z << 5) + this.pos.z));
    }

    public MapChunk created() {
        this.region.update(true);
        return this;
    }

    public MapChunk offsetBlocking(int x, int z) {
        XZ pos = this.getActualPos().offset(x, z);
        return this.region.dimension.getRegion(XZ.regionFromChunk((int)pos.x, (int)pos.z)).getDataBlocking().getChunk(pos);
    }

    public void updateFrom(Date now, SendChunkPacket.SingleChunk packet, UUID t) {
        this.team = (ClientTeam)ClientTeamManager.INSTANCE.teamMap.get(t);
        this.claimedDate = this.team == null ? null : new Date(now.getTime() - packet.relativeTimeClaimed);
        this.forceLoadedDate = packet.forceLoaded && this.claimedDate != null ? new Date(now.getTime() - packet.relativeTimeForceLoaded) : null;
        this.region.update(false);
    }
}

