/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.ForgeServerConfig;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeClientConfig
extends ClientConfig {
    public ForgeClientConfig(ForgeConfigSpec.Builder builder) {
        this.microphoneActivationType = ForgeServerConfig.wrapConfigEntry(builder.comment("Microphone activation type").defineEnum("microphone_activation_type", (Enum)MicrophoneActivationType.PTT));
        this.voiceActivationThreshold = ForgeServerConfig.wrapConfigEntry(builder.comment("The threshold for voice activation in dB").defineInRange("voice_activation_threshold", -50.0, -127.0, 0.0));
        this.voiceChatVolume = ForgeServerConfig.wrapConfigEntry(builder.comment("The voice chat volume").defineInRange("voice_chat_volume", 1.0, 0.0, 2.0));
        this.microphoneAmplification = ForgeServerConfig.wrapConfigEntry(builder.comment("The voice chat microphone amplification").defineInRange("microphone_amplification", 1.0, 0.0, 4.0));
        this.outputBufferSize = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The size of the audio output buffer in packets", "Higher values mean a higher latency, but less crackles", "Increase this value if you have an unstable internet connection"}).defineInRange("output_buffer_size", 5, 1, 16));
        this.audioPacketThreshold = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The maximum amount of audio packets that are held back, if a packet arrives out of order or gets dropped", "This prevents discarding audio packets that are slightly out of order", "Set this to 0 to disable"}).defineInRange("audio_packet_threshold", 3, 0, 16));
        this.deactivationDelay = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The time it takes for the microphone to deactivate when using voice activation", "A value of 1 means 20 milliseconds, 2=40 ms, 3=60 ms, ..."}).defineInRange("voice_deactivation_delay", 25, 0, 100));
        this.microphone = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The microphone used by the voice chat", "Empty for default device"}).define("microphone", (Object)""));
        this.speaker = ForgeServerConfig.wrapConfigEntry(builder.worldRestart().comment(new String[]{"The speaker used by the voice chat", "Empty for default device"}).define("speaker", (Object)""));
        this.muted = ForgeServerConfig.wrapConfigEntry(builder.comment("If the microphone is muted (only when using voice activation)").define("muted", false));
        this.disabled = ForgeServerConfig.wrapConfigEntry(builder.comment("If the voice chat is disabled (sound and microphone off)").define("disabled", false));
        this.hideIcons = ForgeServerConfig.wrapConfigEntry(builder.comment("If the voice chat icons should be hidden").define("hide_icons", false));
        this.showGroupHUD = ForgeServerConfig.wrapConfigEntry(builder.comment("If the group HUD should be visible").define("show_group_hud", true));
        this.showOwnGroupIcon = ForgeServerConfig.wrapConfigEntry(builder.comment("If the own icon should be shown when in a group").define("show_own_group_icon", true));
        this.groupHudIconScale = ForgeServerConfig.wrapConfigEntry(builder.comment("The scale of the group HUD").defineInRange("group_hud_icon_scale", 2.0, 0.01, 10.0));
        this.groupPlayerIconOrientation = ForgeServerConfig.wrapConfigEntry(builder.comment("The orientation of the player icons in the group HUD").defineEnum("group_player_icon_orientation", (Enum)GroupPlayerIconOrientation.VERTICAL));
        this.groupPlayerIconPosX = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The X position of the player icons in the group HUD", "Negative values mean anchoring to the right"}).defineInRange("group_player_icon_pos_x", 4, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.groupPlayerIconPosY = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The Y position of the player icons in the group HUD", "Negative values mean anchoring to the bottom"}).defineInRange("group_player_icon_pos_y", 4, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.hudIconPosX = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The X position of the HUD icons", "Negative values mean anchoring to the right"}).defineInRange("hud_icon_pos_x", 16, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.hudIconPosY = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The Y position of the HUD icons", "Negative values mean anchoring to the bottom"}).defineInRange("hud_icon_pos_y", -16, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.hudIconScale = ForgeServerConfig.wrapConfigEntry(builder.comment("The scale of the HUD icons").defineInRange("hud_icon_scale", 1.0, 0.01, 10.0));
        this.recordingDestination = ForgeServerConfig.wrapConfigEntry(builder.comment(new String[]{"The location where recordings should be saved", "Leave empty for default location"}).define("recording_destination", (Object)""));
        this.denoiser = ForgeServerConfig.wrapConfigEntry(builder.comment("If noise cancellation should be enabled").define("denoiser", false));
        this.runLocalServer = ForgeServerConfig.wrapConfigEntry(builder.comment("If voice chat should work in singleplayer/LAN worlds").define("run_local_server", true));
        this.javaMicrophoneImplementation = ForgeServerConfig.wrapConfigEntry(builder.comment("Whether to use the Java implementation of microphone capturing instead of OpenAL").define("java_microphone_implementation", Platform.isMac()));
        this.macosMicrophoneWorkaround = ForgeServerConfig.wrapConfigEntry(builder.comment("If the microphone workaround hack should be used (MacOS only)").define("macos_microphone_workaround", Platform.isMac()));
        this.showFakePlayersDisconnected = ForgeServerConfig.wrapConfigEntry(builder.comment("If fake players should have the disconnected icon above their head").define("show_fake_players_disconnected", false));
        this.offlinePlayerVolumeAdjustment = ForgeServerConfig.wrapConfigEntry(builder.comment("If the volume adjustment GUI should also show offline players").define("offline_player_volume_adjustment", false));
        this.audioType = ForgeServerConfig.wrapConfigEntry(builder.comment("The 3D audio type").defineEnum("audio_type", (Enum)AudioType.NORMAL));
    }
}

