/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.config;

import de.maxhenkel.voicechat.configbuilder.PropertyConfig;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerVolumeConfig
extends PropertyConfig {
    private final Map<UUID, Double> volumes;

    public PlayerVolumeConfig(Path path) {
        super(path);
        Map<String, Object> entries = this.getEntries();
        this.volumes = new HashMap<UUID, Double>(entries.size());
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            try {
                this.volumes.put(UUID.fromString(entry.getKey()), Double.parseDouble(entry.getValue().toString()));
            }
            catch (Exception exception) {}
        }
    }

    public double getVolume(UUID uuid, double def) {
        Double volume = this.volumes.get(uuid);
        if (volume == null) {
            return this.setVolume(uuid, def);
        }
        return volume;
    }

    public double getVolume(UUID playerID) {
        return this.getVolume(playerID, 1.0);
    }

    public double setVolume(UUID uuid, double value) {
        this.volumes.put(uuid, value);
        this.properties.put(uuid.toString(), String.valueOf(value));
        return value;
    }

    public Map<UUID, Double> getVolumes() {
        return Collections.unmodifiableMap(this.volumes);
    }
}

