/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.debug;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.microphone.MicrophoneManager;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.lwjgl.openal.AL11;

public class DebugReport {
    private static final SimpleDateFormat FILE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final SimpleDateFormat TEXT_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final StringBuilder builder = new StringBuilder();

    private DebugReport() {
    }

    public static void generateReport(Player player) {
        try {
            Path path = DebugReport.generateReport();
            player.m_6352_((Component)new TranslatableComponent("message.voicechat.saved_debug_report", new Object[]{new TextComponent(path.normalize().toString()).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("message.voicechat.open"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.normalize().toString())))}), Util.f_137441_);
        }
        catch (IOException e) {
            player.m_6352_((Component)new TranslatableComponent("message.voicechat.saved_debug_report_failed", new Object[]{e.getMessage()}), Util.f_137441_);
            e.printStackTrace();
        }
    }

    public static Path generateReport() throws IOException {
        DebugReport report = new DebugReport();
        report.generate();
        Path debugFolder = report.getDebugFolder();
        debugFolder.toFile().mkdirs();
        Path location = debugFolder.resolve("voicechat-" + FILE_FORMAT.format(Calendar.getInstance().getTime()) + ".txt");
        FileUtils.writeStringToFile((File)location.toFile(), (String)report.builder.toString(), (Charset)StandardCharsets.UTF_8);
        Voicechat.LOGGER.info("Saved voicechat debug report to {}", (Object)location.normalize().toString());
        return location;
    }

    private Path getDebugFolder() {
        return CommonCompatibilityManager.INSTANCE.getGameDirectory().resolve("debug");
    }

    private void generate() {
        this.appendHeader();
        this.divider();
        this.appendMods();
        this.divider();
        this.appendKeyBinds();
        this.divider();
        this.appendMics();
        this.divider();
        this.appendSpeakers();
        this.divider();
        this.appendOS();
        this.divider();
        this.appendJava();
        this.divider();
        this.appendOpenAL();
        this.divider();
        this.appendServer();
        this.divider();
        this.appendConfig();
        this.divider();
        this.appendPlayerVolumes();
    }

    private void appendHeader() {
        this.addLine("Simple Voice Chat Debug Report");
        this.addLine(TEXT_FORMAT.format(Calendar.getInstance().getTime()));
        this.addLine("Compatibility version " + Voicechat.COMPATIBILITY_VERSION);
        this.addLine("");
    }

    private void appendMods() {
        this.addLine("Loaded mods");
        this.addLine("");
        this.addLine(CommonCompatibilityManager.INSTANCE.listLoadedMods());
    }

    private void appendKeyBinds() {
        this.addLine("Keybinds");
        this.addLine("");
        this.addLine(CommonCompatibilityManager.INSTANCE.listKeybinds());
    }

    private void appendMics() {
        this.addLine("Input Devices");
        this.addLine("");
        MicrophoneManager.deviceNames().forEach(this::addLine);
        this.addLine("");
    }

    private void appendSpeakers() {
        this.addLine("Output Devices");
        this.addLine("");
        SoundManager.getAllSpeakers().forEach(this::addLine);
        this.addLine("");
    }

    private void appendOS() {
        this.addLine("Operating System");
        this.addLine(System.getProperty("os.name"));
        this.addLine(System.getProperty("os.version"));
        this.addLine(System.getProperty("os.arch"));
        this.addLine("");
    }

    private void appendJava() {
        this.addLine("Java");
        this.addLine("");
        this.addLine("Version: " + System.getProperty("java.version"));
        try {
            ProcessHandle current = ProcessHandle.current();
            current.info().commandLine().ifPresent(s -> this.addLine("Command line: " + s));
            current.parent().ifPresent(processHandle -> this.addLine("Parent process: " + processHandle.info().commandLine().orElse("UNKNOWN")));
            this.addLine("");
        }
        catch (Exception e) {
            this.addLine("Process: ERROR (" + e.getMessage() + ")");
        }
    }

    private void appendOpenAL() {
        this.addLine("OpenAL");
        this.addLine("");
        this.addLine("Version: " + AL11.alGetString((int)45058));
        this.addLine("Vendor: " + AL11.alGetString((int)45057));
    }

    private void appendServer() {
        ClientVoicechat client;
        this.addLine("Connection");
        Minecraft mc = Minecraft.m_91087_();
        this.addLine(mc.m_91090_() ? "Local Server" : "Dedicated Server");
        if (!mc.m_91090_()) {
            try {
                SocketAddress socketAddress = ClientCompatibilityManager.INSTANCE.getSocketAddress(mc.m_91403_().m_6198_());
                this.addLine("Server address: " + socketAddress.toString());
            }
            catch (Exception e) {
                this.addLine("Server address: N/A (" + e.getMessage() + ")");
            }
        }
        if ((client = ClientManager.getClient()) != null && client.getConnection() != null) {
            ClientVoicechatConnection connection = client.getConnection();
            this.addLine("");
            this.addLine("Voice chat connected");
            this.addLine("Address: " + connection.getAddress().toString());
            this.addLine("Port: " + connection.getData().getServerPort());
            this.addLine("Codec: " + connection.getData().getCodec().toString());
            this.addLine(connection.getData().groupsEnabled() ? "Groups enabled" : "Groups disabled");
            this.addLine("Sample rate: 48000");
            this.addLine("Frame size: 960");
            this.addLine("MTU size: " + connection.getData().getMtuSize());
            this.addLine("Distance: " + connection.getData().getVoiceChatDistance());
            this.addLine("Fade distance: " + connection.getData().getVoiceChatFadeDistance());
            this.addLine("Crouch distance multiplier: " + connection.getData().getCrouchDistanceMultiplier());
            this.addLine("Whisper distance multiplier: " + connection.getData().getWhisperDistanceMultiplier());
            this.addLine("Authenticated: " + connection.isAuthenticated());
            this.addLine("Recording: " + (client.getRecorder() != null));
            this.addLine("");
        } else {
            this.addLine("");
            this.addLine("Voice chat not connected");
            this.addLine("");
        }
    }

    private void appendConfig() {
        this.addLine("Client Configuration");
        this.addLine("");
        for (Map.Entry<String, Object> o : VoicechatClient.CLIENT_CONFIG.hideIcons.getConfig().getEntries().entrySet()) {
            this.addLine(o.getKey() + ": " + o.getValue());
        }
        this.addLine("");
    }

    private void appendPlayerVolumes() {
        this.addLine("Player volumes");
        this.addLine("");
        for (Map.Entry<String, Object> o : VoicechatClient.VOLUME_CONFIG.getEntries().entrySet()) {
            this.addLine(o.getKey() + ": " + o.getValue());
        }
        this.addLine("");
    }

    private void divider() {
        this.addLine("#####################################################################################################\n");
    }

    private void addLine(String str) {
        this.builder.append(str).append("\n");
    }
}

