/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.BooleanConfigButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.Denoiser;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat_settings.png");
    private static final Component TITLE = new TranslatableComponent("gui.voicechat.voice_chat_settings.title");
    private static final Component ENABLED = new TranslatableComponent("message.voicechat.enabled");
    private static final Component DISABLED = new TranslatableComponent("message.voicechat.disabled");
    private static final Component ADJUST_VOLUMES = new TranslatableComponent("message.voicechat.adjust_volumes");
    private static final Component SELECT_MICROPHONE = new TranslatableComponent("message.voicechat.select_microphone");
    private static final Component SELECT_SPEAKER = new TranslatableComponent("message.voicechat.select_speaker");
    private static final Component BACK = new TranslatableComponent("message.voicechat.back");
    @Nullable
    private final Screen parent;

    public VoiceChatSettingsScreen(@Nullable Screen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int y = this.guiTop + 20;
        this.m_142416_((GuiEventListener)new VoiceSoundSlider(this.guiLeft + 10, y, this.xSize - 20, 20));
        this.m_142416_((GuiEventListener)new MicAmplificationSlider(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        BooleanConfigButton denoiser = (BooleanConfigButton)this.m_142416_((GuiEventListener)new BooleanConfigButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.denoiser, enabled -> new TranslatableComponent("message.voicechat.denoiser", new Object[]{enabled != false ? ENABLED : DISABLED})));
        if (Denoiser.createDenoiser() == null) {
            denoiser.f_93623_ = false;
        }
        VoiceActivationSlider voiceActivationSlider = new VoiceActivationSlider(this.guiLeft + 10, (y += 21) + 21, this.xSize - 20, 20);
        this.m_142416_((GuiEventListener)new MicActivationButton(this.guiLeft + 10, y, this.xSize - 20, 20, voiceActivationSlider));
        y += 21;
        this.m_142416_((GuiEventListener)voiceActivationSlider);
        final MicTestButton micTestButton = new MicTestButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20, voiceActivationSlider);
        this.m_142416_((GuiEventListener)micTestButton);
        this.m_142416_((GuiEventListener)new EnumButton<AudioType>(this.guiLeft + 10, y += 21, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            @Override
            protected Component getText(AudioType type) {
                return new TranslatableComponent("message.voicechat.audio_type", new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        y += 21;
        if (this.isIngame()) {
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, y, this.xSize - 20, 20, ADJUST_VOLUMES, button -> this.f_96541_.m_91152_((Screen)new PlayerVolumesScreen())));
            y += 21;
        }
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, y, this.xSize / 2 - 15, 20, SELECT_MICROPHONE, button -> this.f_96541_.m_91152_((Screen)new SelectMicrophoneScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize / 2 + 6, y, this.xSize / 2 - 15, 20, SELECT_SPEAKER, button -> this.f_96541_.m_91152_((Screen)new SelectSpeakerScreen(this))));
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, y, this.xSize - 20, 20, BACK, button -> this.f_96541_.m_91152_(this.parent)));
        }
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (this.isIngame()) {
            this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)TITLE);
        this.f_96547_.m_92877_(poseStack, TITLE.m_7532_(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), this.getFontColor());
    }
}

