/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.ForgeNetManager;
import de.maxhenkel.voicechat.net.NetManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeCommonCompatibilityManager
extends CommonCompatibilityManager {
    private final List<Consumer<MinecraftServer>> serverStartingEvents = new ArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<MinecraftServer>> serverStoppingEvents = new ArrayList<Consumer<MinecraftServer>>();
    private final List<Consumer<CommandDispatcher<CommandSourceStack>>> registerServerCommandsEvents = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();
    private final List<Consumer<ServerPlayer>> playerLoggedInEvents = new ArrayList<Consumer<ServerPlayer>>();
    private final List<Consumer<ServerPlayer>> playerLoggedOutEvents = new ArrayList<Consumer<ServerPlayer>>();
    private ForgeNetManager netManager;

    @SubscribeEvent
    public void serverStarting(ServerStartedEvent event) {
        this.serverStartingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent event) {
        this.serverStoppingEvents.forEach(consumer -> consumer.accept(event.getServer()));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        this.registerServerCommandsEvents.forEach(consumer -> consumer.accept(event.getDispatcher()));
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.playerLoggedInEvents.forEach(consumer -> consumer.accept(player2));
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.playerLoggedOutEvents.forEach(consumer -> consumer.accept(player2));
        }
    }

    @Override
    public String getModVersion() {
        return ModList.get().getModFileById("voicechat").versionString();
    }

    @Override
    public String getModName() {
        return ModList.get().getMods().stream().filter(info -> info.getModId().equals("voicechat")).findAny().map(IModInfo::getDisplayName).orElse("voicechat");
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public void onServerStarting(Consumer<MinecraftServer> onServerStarting) {
        this.serverStartingEvents.add(onServerStarting);
    }

    @Override
    public void onServerStopping(Consumer<MinecraftServer> onServerStopping) {
        this.serverStoppingEvents.add(onServerStopping);
    }

    @Override
    public void onPlayerLoggedIn(Consumer<ServerPlayer> onPlayerLoggedIn) {
        this.playerLoggedInEvents.add(onPlayerLoggedIn);
    }

    @Override
    public void onPlayerLoggedOut(Consumer<ServerPlayer> onPlayerLoggedOut) {
        this.playerLoggedOutEvents.add(onPlayerLoggedOut);
    }

    @Override
    public void onRegisterServerCommands(Consumer<CommandDispatcher<CommandSourceStack>> onRegisterServerCommands) {
        this.registerServerCommandsEvents.add(onRegisterServerCommands);
    }

    @Override
    public NetManager getNetManager() {
        if (this.netManager == null) {
            this.netManager = new ForgeNetManager();
        }
        return this.netManager;
    }

    @Override
    public String listLoadedMods() {
        StringBuilder sb = new StringBuilder();
        for (IModInfo mod : ModList.get().getMods()) {
            sb.append("Mod ID: " + mod.getModId());
            sb.append("\n");
            sb.append("Name: " + mod.getDisplayName());
            sb.append("\n");
            sb.append("Version: " + mod.getVersion().getQualifier());
            sb.append("\n");
            sb.append("Dependencies: " + mod.getDependencies().stream().map(IModInfo.ModVersion::getModId).collect(Collectors.joining(", ")));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    @Override
    public String listKeybinds() {
        StringBuilder sb = new StringBuilder();
        for (KeyMapping mapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            sb.append(mapping.m_90860_() + "(" + mapping.m_90858_() + "): " + mapping.getKey().m_84874_() + " (" + mapping.m_90861_().m_84874_() + ")");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public List<VoicechatPlugin> loadPlugins() {
        ArrayList<VoicechatPlugin> plugins = new ArrayList<VoicechatPlugin>();
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(annotationData -> {
            if (annotationData.annotationType().getClassName().equals(ForgeVoicechatPlugin.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(annotationData.memberName());
                    if (VoicechatPlugin.class.isAssignableFrom(clazz)) {
                        VoicechatPlugin plugin = (VoicechatPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        plugins.add(plugin);
                    }
                }
                catch (Exception e) {
                    Voicechat.LOGGER.warn("Failed to load plugin '{}': {}", (Object)annotationData.memberName(), (Object)e.getMessage());
                }
            }
        }));
        return plugins;
    }
}

