/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");

    public static void renderIcons(PoseStack matrixStack) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        matrixStack.m_85836_();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            matrixStack.m_85837_((double)mc.m_91268_().m_85445_(), 0.0, 0.0);
        }
        if (posY < 0) {
            matrixStack.m_85837_(0.0, (double)mc.m_91268_().m_85446_(), 0.0);
        }
        matrixStack.m_85837_((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        matrixStack.m_85841_(scale, scale, 1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            matrixStack.m_85836_();
            if (vertical) {
                if (posY < 0) {
                    matrixStack.m_85837_(0.0, (double)i * -11.0, 0.0);
                } else {
                    matrixStack.m_85837_(0.0, (double)i * 11.0, 0.0);
                }
            } else if (posX < 0) {
                matrixStack.m_85837_((double)i * -11.0, 0.0, 0.0);
            } else {
                matrixStack.m_85837_((double)i * 11.0, 0.0, 0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TALK_OUTLINE);
                Screen.m_93133_((PoseStack)matrixStack, (int)(posX < 0 ? -10 : 0), (int)(posY < 0 ? -10 : 0), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)16, (int)16);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)GameProfileUtils.getSkin(state.getUuid()));
            Screen.m_93133_((PoseStack)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            Screen.m_93133_((PoseStack)matrixStack, (int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (state.isDisabled()) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(posX < 0 ? -9.0 : 1.0, posY < 0 ? -9.0 : 1.0, 0.0);
                matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)SPEAKER_OFF_ICON);
                Screen.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.m_85849_();
            }
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        ClientGroup group = ClientManager.getPlayerStateManager().getGroup();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().getId().equals(group.getId())) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

