/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class LocationSoundPacket
extends SoundPacket<LocationSoundPacket> {
    protected Vec3 location;

    public LocationSoundPacket(UUID sender, Vec3 location, byte[] data, long sequenceNumber) {
        super(sender, data, sequenceNumber);
        this.location = location;
    }

    public LocationSoundPacket(UUID sender, short[] data, Vec3 location) {
        super(sender, data);
        this.location = location;
    }

    public LocationSoundPacket() {
    }

    public Vec3 getLocation() {
        return this.location;
    }

    @Override
    public LocationSoundPacket fromBytes(FriendlyByteBuf buf) {
        LocationSoundPacket soundPacket = new LocationSoundPacket();
        soundPacket.sender = buf.m_130259_();
        soundPacket.location = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        soundPacket.data = buf.m_130052_();
        soundPacket.sequenceNumber = buf.readLong();
        return soundPacket;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.sender);
        buf.writeDouble(this.location.f_82479_);
        buf.writeDouble(this.location.f_82480_);
        buf.writeDouble(this.location.f_82481_);
        buf.m_130087_(this.data);
        buf.writeLong(this.sequenceNumber);
    }
}

