/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.theillusivec4.comforts.common.block.ComfortsBaseBlock;
import top.theillusivec4.comforts.common.block.HammockBlock;

public class RopeAndNailBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SUPPORTING = BooleanProperty.m_61465_((String)"supporting");
    private static final Map<Direction, VoxelShape> SHAPES_R = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0)));
    private static final Map<Direction, VoxelShape> SHAPES_S = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)6.0, (double)3.0, (double)9.0, (double)10.0, (double)8.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)8.0, (double)7.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)9.0, (double)3.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)6.0, (double)7.0, (double)8.0, (double)10.0)));

    public RopeAndNailBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60918_(SoundType.f_56743_).m_60978_(0.2f));
        this.setRegistryName("comforts", "rope_and_nail");
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SUPPORTING) != false ? SHAPES_S.get(state.m_61143_((Property)HORIZONTAL_FACING)) : SHAPES_R.get(state.m_61143_((Property)HORIZONTAL_FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = worldIn.m_8055_(blockpos);
        boolean valid = blockstate.m_60783_((BlockGetter)worldIn, blockpos, direction);
        if (!valid && worldIn instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)worldIn;
            RopeAndNailBlock.dropHammock((Level)world, pos, state);
        }
        return valid;
    }

    private static void dropHammock(Level world, BlockPos pos, BlockState state) {
        BlockPos frontPos = pos.m_142300_((Direction)state.m_61143_((Property)HORIZONTAL_FACING));
        BlockState frontState = world.m_8055_(frontPos);
        if (((Boolean)state.m_61143_((Property)SUPPORTING)).booleanValue() && frontState.m_60734_() instanceof HammockBlock) {
            BedPart bedpart = (BedPart)frontState.m_61143_((Property)BedBlock.f_49440_);
            boolean isHead = bedpart == BedPart.HEAD;
            Direction frontDirection = (Direction)frontState.m_61143_((Property)HORIZONTAL_FACING);
            BlockPos otherPos = frontPos.m_142300_(HammockBlock.getDirectionToOther(bedpart, frontDirection));
            if (isHead) {
                RopeAndNailBlock.m_49950_((BlockState)frontState, (Level)world, (BlockPos)frontPos);
            }
            if (((Boolean)frontState.m_61143_((Property)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
                world.m_7731_(frontPos, Blocks.f_49990_.m_49966_(), 35);
            } else {
                world.m_7731_(frontPos, Blocks.f_50016_.m_49966_(), 35);
            }
            HammockBlock.dropRopeSupport(otherPos, frontDirection, !isHead, world);
        }
    }

    public void m_5707_(Level worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        RopeAndNailBlock.dropHammock(worldIn, pos, state);
        super.m_5707_(worldIn, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockstate = this.m_49966_();
        Level worldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : directions = context.m_6232_()) {
            Direction direction1;
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)HORIZONTAL_FACING, (Comparable)(direction1 = direction.m_122424_()))).m_61124_((Property)ComfortsBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_))).m_60710_((LevelReader)worldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)ComfortsBaseBlock.WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return facing.m_122424_() == stateIn.m_61143_((Property)HORIZONTAL_FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    @Nonnull
    public BlockState m_6943_(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SUPPORTING, HORIZONTAL_FACING, ComfortsBaseBlock.WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)ComfortsBaseBlock.WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

