/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelConfigurationWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedModel
implements IModelGeometry<RetexturedModel> {
    private final SimpleBlockModel model;
    private final Set<String> retextured;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new Baked(baked, owner, this.model, transform, RetexturedModel.getAllRetextured(owner, this.model, this.retextured));
    }

    public static Set<String> getAllRetextured(IModelConfiguration owner, SimpleBlockModel model, Set<String> originalSet) {
        HashSet retextured = Sets.newHashSet(originalSet);
        for (Map textures : ModelTextureIteratable.of(owner, model)) {
            textures.forEach((name, either) -> either.ifRight(parent -> {
                if (retextured.contains(parent)) {
                    retextured.add(name);
                }
            }));
        }
        return ImmutableSet.copyOf((Collection)retextured);
    }

    protected RetexturedModel(SimpleBlockModel model, Set<String> retextured) {
        this.model = model;
        this.retextured = retextured;
    }

    public static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final Map<ResourceLocation, BakedModel> cache = new ConcurrentHashMap<ResourceLocation, BakedModel>();
        private final IModelConfiguration owner;
        private final SimpleBlockModel model;
        private final ModelState transform;
        private final Set<String> retextured;

        public Baked(BakedModel baked, IModelConfiguration owner, SimpleBlockModel model, ModelState transform, Set<String> retextured) {
            super(baked);
            this.model = model;
            this.owner = owner;
            this.transform = transform;
            this.retextured = retextured;
        }

        private BakedModel getRetexturedModel(ResourceLocation name) {
            return this.model.bakeDynamic(new RetexturedConfiguration(this.owner, this.retextured, name), this.transform);
        }

        private BakedModel getCachedModel(Block block) {
            return this.cache.computeIfAbsent(ModelHelper.getParticleTexture(block), this::getRetexturedModel);
        }

        public TextureAtlasSprite getParticleIcon(IModelData data) {
            Block block;
            if (this.retextured.contains("particle") && (block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY)) != null) {
                return this.getCachedModel(block).getParticleIcon(data);
            }
            return this.originalModel.getParticleIcon(data);
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            Block block = (Block)data.getData(RetexturedHelper.BLOCK_PROPERTY);
            if (block == null) {
                return this.originalModel.getQuads(state, direction, random, data);
            }
            return this.getCachedModel(block).getQuads(state, direction, random, data);
        }

        public ItemOverrides m_7343_() {
            return RetexturedOverride.INSTANCE;
        }
    }

    private static class RetexturedOverride
    extends ItemOverrides {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int pSeed) {
            if (stack.m_41619_() || !stack.m_41782_()) {
                return originalModel;
            }
            Block block = RetexturedBlockItem.getTexture(stack);
            if (block == Blocks.f_50016_) {
                return originalModel;
            }
            return ((Baked)originalModel).getCachedModel(block);
        }
    }

    public static class RetexturedConfiguration
    extends ModelConfigurationWrapper {
        private final Set<String> retextured;
        private final Material texture;

        public RetexturedConfiguration(IModelConfiguration base, Set<String> retextured, ResourceLocation texture) {
            super(base);
            this.retextured = retextured;
            this.texture = ModelLoaderRegistry.blockMaterial((ResourceLocation)texture);
        }

        @Override
        public boolean isTexturePresent(String name) {
            if (this.retextured.contains(name)) {
                return !MissingTextureAtlasSprite.m_118071_().equals((Object)this.texture.m_119203_());
            }
            return super.isTexturePresent(name);
        }

        @Override
        public Material resolveTexture(String name) {
            if (this.retextured.contains(name)) {
                return this.texture;
            }
            return super.resolveTexture(name);
        }
    }

    public static class Loader
    implements IModelLoader<RetexturedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public RetexturedModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
            Set<String> retextured = Loader.getRetextured(json);
            return new RetexturedModel(model, retextured);
        }

        public static Set<String> getRetextured(JsonObject json) {
            if (json.has("retextured")) {
                JsonElement retextured = json.get("retextured");
                if (retextured.isJsonArray()) {
                    JsonArray array = retextured.getAsJsonArray();
                    if (array.size() == 0) {
                        throw new JsonSyntaxException("Must have at least one texture in retextured");
                    }
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (int i = 0; i < array.size(); ++i) {
                        builder.add((Object)GsonHelper.m_13805_((JsonElement)array.get(i), (String)("retextured[" + i + "]")));
                    }
                    return builder.build();
                }
                if (retextured.isJsonPrimitive()) {
                    return ImmutableSet.of((Object)retextured.getAsString());
                }
            }
            throw new JsonSyntaxException("Missing retextured, expected to find a String or a JsonArray");
        }
    }
}

