/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.model.ValhelsiaCapeModel;

public class ValhelsiaCapeLayer<T extends AbstractClientPlayer, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ValhelsiaCapeModel<T> capeModel;

    public ValhelsiaCapeLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.capeModel = new ValhelsiaCapeModel(modelSet.m_171103_(ValhelsiaCapeModel.VALHELSIA_CAPE));
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = player.m_142081_();
        List<Cosmetic> cosmetics = cosmeticsManager.getCosmeticsForPlayer(uuid, CosmeticsCategory.BACK);
        Cosmetic activeCosmetic = cosmeticsManager.getActiveCosmeticForPlayer(uuid, CosmeticsCategory.BACK);
        if (stack.m_41720_() == Items.f_42741_ || activeCosmetic == null || !activeCosmetic.getName().contains("cape") || !cosmetics.contains(activeCosmetic)) {
            return;
        }
        ResourceLocation texture = cosmeticsManager.getCosmeticTexture(activeCosmetic);
        if (texture == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_36102_, (double)((AbstractClientPlayer)player).f_36105_) - Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_19854_, (double)player.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_36103_, (double)((AbstractClientPlayer)player).f_36106_) - Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_19855_, (double)player.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_36104_, (double)((AbstractClientPlayer)player).f_36075_) - Mth.m_14139_((double)partialTicks, (double)((AbstractClientPlayer)player).f_19856_, (double)player.m_20189_());
        float f = ((AbstractClientPlayer)player).f_20884_ + (((AbstractClientPlayer)player).f_20883_ - ((AbstractClientPlayer)player).f_20884_);
        double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
        float f1 = (float)d1 * 10.0f;
        f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
        float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
        f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        float f4 = Mth.m_14179_((float)partialTicks, (float)((AbstractClientPlayer)player).f_36099_, (float)((AbstractClientPlayer)player).f_36100_);
        f1 += Mth.m_14031_((float)(Mth.m_14179_((float)partialTicks, (float)((AbstractClientPlayer)player).f_19867_, (float)((AbstractClientPlayer)player).f_19787_) * 6.0f)) * 32.0f * f4;
        if (player.m_6047_()) {
            f1 += stack.m_41619_() ? 25.0f : 35.0f;
            poseStack.m_85837_(0.0, 0.2, 0.0);
        } else {
            f1 += 3.0f;
        }
        if (!stack.m_41619_()) {
            poseStack.m_85837_(0.0, -0.07, 0.0);
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)texture));
        this.capeModel.setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        poseStack.m_85837_(0.0, 0.075, 0.0);
        this.capeModel.renderPinToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Math.min(70.0f, 6.0f + f2 / 2.0f + f1)));
        poseStack.m_85837_(0.0, -0.115, -0.045);
        this.capeModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

