/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.event;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.helper.CounterHelper;
import net.valhelsia.valhelsia_core.common.network.NetworkHandler;
import net.valhelsia.valhelsia_core.common.network.UpdateCosmeticsPacket;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.config.ConfigError;
import net.valhelsia.valhelsia_core.core.registry.RegistryManager;

@Mod.EventBusSubscriber
public class PlayerEvents {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("valhelsia_core", "counters"), (ICapabilityProvider)new CounterProvider(CounterHelper.getCounters()));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
        for (RegistryManager registryManager : ValhelsiaCore.REGISTRY_MANAGERS) {
            AbstractConfigValidator configValidator;
            if (registryManager.getConfigValidator() == null || (configValidator = registryManager.getConfigValidator()).getType() != AbstractConfigValidator.Type.WORLD_LOAD) continue;
            configValidator.validate();
            configValidator.getErrors().forEach(configError -> configError.setModID(registryManager.getModId()));
            errors.addAll(configValidator.getErrors());
        }
        if (!errors.isEmpty()) {
            errors.forEach(configError -> {
                player.m_6352_((Component)new TextComponent(configError.getModID()).m_130940_(ChatFormatting.UNDERLINE), player.m_142081_());
                player.m_6352_((Component)new TranslatableComponent("gui.valhelsia_core.config.error").m_130946_(": " + configError.getPath()), player.m_142081_());
                player.m_6352_((Component)configError.getErrorMessage(), player.m_142081_());
            });
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getPlayer();
        UUID uuid = player.m_142081_();
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            NetworkHandler.sendTo(target, new UpdateCosmeticsPacket(uuid, CosmeticsManager.getInstance().getActiveCosmeticsForPlayer(uuid)));
        }
    }
}

