/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.loot.modifiers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AppendLootTableModifier
extends LootModifier {
    private final ResourceLocation lootTable;
    boolean reentryPrevention = false;

    public AppendLootTableModifier(LootItemCondition[] conditions, ResourceLocation lootTable) {
        super(conditions);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.reentryPrevention) {
            return generatedLoot;
        }
        this.reentryPrevention = true;
        LootTable lootTable = context.m_78940_(this.lootTable);
        List extras = lootTable.m_79129_(context);
        generatedLoot.addAll(extras);
        this.reentryPrevention = false;
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AppendLootTableModifier> {
        private static final Gson GSON = Deserializers.m_78798_().create();

        public AppendLootTableModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"add_loot"));
            return new AppendLootTableModifier(conditions, lootTable);
        }

        public JsonObject write(AppendLootTableModifier instance) {
            JsonObject object = new JsonObject();
            object.addProperty("add_loot", instance.lootTable.toString());
            JsonElement conditions = GSON.toJsonTree((Object)instance.conditions);
            object.add("conditions", conditions);
            return object;
        }
    }
}

