/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.api.AquacultureAPI;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishMountEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private static final Logger PRIVATE_LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(FishMountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float itemDropChance = 1.0f;
    public Entity entity;

    public FishMountEntity(EntityType<? extends FishMountEntity> type, Level world) {
        super(type, world);
    }

    public FishMountEntity(EntityType<? extends FishMountEntity> type, Level world, BlockPos blockPos, Direction direction) {
        super(type, world, blockPos);
        this.m_6022_(direction);
    }

    public FishMountEntity(PlayMessages.SpawnEntity spawnPacket, Level world) {
        this((EntityType<? extends FishMountEntity>)((EntityType)ForgeRegistries.ENTITIES.getValue(spawnPacket.getAdditionalData().m_130281_())), world);
    }

    protected float m_6380_(Pose pose, EntityDimensions size) {
        return 0.0f;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_6022_(Direction direction) {
        Validate.notNull((Object)direction);
        this.f_31699_ = direction;
        if (direction.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * direction.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    public boolean m_7088_() {
        if (!this.f_19853_.m_45786_((Entity)this)) {
            return false;
        }
        BlockState state = this.f_19853_.m_8055_(this.f_31698_.m_142300_(this.f_31699_.m_122424_()));
        return (state.m_60767_().m_76333_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)state)) && this.f_19853_.m_6249_((Entity)this, this.m_142469_(), f_31697_).isEmpty();
    }

    protected void m_7087_() {
        if (this.f_31699_ != null) {
            double d0 = 0.46875;
            double posX = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * d0;
            double posY = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * d0;
            double posZ = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * d0;
            this.m_20343_(posX, posY, posZ);
            double x1 = (double)this.m_7076_() / 32.0;
            double x2 = (double)this.m_7076_() / 32.0;
            double y1 = (double)this.m_7068_() / 32.0;
            double y2 = (double)this.m_7068_() / 32.0;
            double z1 = (double)this.m_7076_() / 32.0;
            double z2 = (double)this.m_7076_() / 32.0;
            switch (this.f_31699_.m_122434_()) {
                case X: {
                    x1 = (this.f_31699_.m_122429_() < 0 ? 3.0 : 1.0) / 32.0;
                    x2 = (this.f_31699_.m_122429_() > 0 ? 3.0 : 1.0) / 32.0;
                    break;
                }
                case Y: {
                    y1 = (this.f_31699_.m_122430_() < 0 ? 3.0 : 1.0) / 32.0;
                    y2 = (this.f_31699_.m_122430_() > 0 ? 3.0 : 1.0) / 32.0;
                    z1 = 0.25;
                    z2 = 0.25;
                    break;
                }
                case Z: {
                    z1 = (this.f_31699_.m_122431_() < 0 ? 3.0 : 1.0) / 32.0;
                    z2 = (this.f_31699_.m_122431_() > 0 ? 3.0 : 1.0) / 32.0;
                }
            }
            this.m_20011_(new AABB(posX - x1, posY - y1, posZ - z1, posX + x2, posY + y2, posZ + z2));
        }
    }

    public void m_6074_() {
        this.setDisplayedItem(ItemStack.f_41583_);
        super.m_6074_();
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19372_() && !this.getDisplayedItem().m_41619_()) {
            if (!this.f_19853_.f_46443_) {
                this.dropItemOrSelf(source.m_7639_(), false);
                this.m_5496_(AquaSounds.FISH_MOUNT_REMOVED, 1.0f, 1.0f);
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public int m_7076_() {
        return 12;
    }

    public int m_7068_() {
        return 8;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * FishMountEntity.m_20150_()) * d0;
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        this.m_5496_(AquaSounds.FISH_MOUNT_BROKEN, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    public void m_7084_() {
        this.m_5496_(AquaSounds.FISH_MOUNT_PLACED, 1.0f, 1.0f);
    }

    private void dropItemOrSelf(@Nullable Entity entity, boolean shouldDropSelf) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            if (entity == null) {
                this.setDisplayedItem(ItemStack.f_41583_);
            }
        } else {
            ItemStack displayStack = this.getDisplayedItem();
            this.setDisplayedItem(ItemStack.f_41583_);
            if (entity instanceof Player) {
                Player playerentity = (Player)entity;
                if (playerentity.m_150110_().f_35937_) {
                    this.setDisplayedItem(ItemStack.f_41583_);
                    return;
                }
            }
            if (shouldDropSelf) {
                this.m_19998_((ItemLike)this.getItem());
            }
            if (!displayStack.m_41619_()) {
                displayStack = displayStack.m_41777_();
                if (this.f_19796_.nextFloat() < this.itemDropChance) {
                    this.m_19983_(displayStack);
                }
            }
        }
    }

    private Item getItem() {
        ResourceLocation location = this.m_6095_().getRegistryName();
        if (ForgeRegistries.ITEMS.containsKey(location) && location != null) {
            return (Item)ForgeRegistries.ITEMS.getValue(location);
        }
        return Items.f_41852_;
    }

    @Nonnull
    public ItemStack getDisplayedItem() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public void setDisplayedItem(@Nonnull ItemStack stack) {
        this.setDisplayedItemWithUpdate(stack, true);
    }

    public void setDisplayedItemWithUpdate(@Nonnull ItemStack stack, boolean shouldUpdate) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
        }
        this.m_20088_().m_135381_(ITEM, (Object)stack);
        if (!stack.m_41619_()) {
            this.m_5496_(AquaSounds.FISH_MOUNT_ADD_ITEM, 1.0f, 1.0f);
        }
        if (shouldUpdate && this.f_31698_ != null) {
            this.f_19853_.m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    public void m_8061_(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            this.setDisplayedItem(stack);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(ITEM)) {
            ItemStack displayStack = this.getDisplayedItem();
            if (displayStack != null && !displayStack.m_41619_()) {
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(displayStack.m_41720_().getRegistryName());
                if (entityType != null && entityType != EntityType.f_20510_) {
                    this.entity = entityType.m_20615_(this.f_19853_);
                }
            } else {
                this.entity = null;
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.getDisplayedItem().m_41619_()) {
            compound.m_128365_("Item", (Tag)this.getDisplayedItem().m_41739_(new CompoundTag()));
            compound.m_128350_("ItemDropChance", this.itemDropChance);
        }
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag nbt = compound.m_128469_("Item");
        if (nbt != null && !nbt.m_128456_()) {
            ItemStack displayStack;
            ItemStack nbtStack = ItemStack.m_41712_((CompoundTag)nbt);
            if (nbtStack.m_41619_()) {
                PRIVATE_LOGGER.warn("Unable to load item from: {}", (Object)nbt);
            }
            if (!(displayStack = this.getDisplayedItem()).m_41619_() && !ItemStack.m_41728_((ItemStack)nbtStack, (ItemStack)displayStack)) {
                this.setDisplayedItem(ItemStack.f_41583_);
            }
            this.setDisplayedItemWithUpdate(nbtStack, false);
            if (compound.m_128425_("ItemDropChance", 99)) {
                this.itemDropChance = compound.m_128457_("ItemDropChance");
            }
        }
        this.m_6022_(Direction.m_122376_((int)compound.m_128445_("Facing")));
    }

    @Nonnull
    public InteractionResult m_6096_(Player player, @Nonnull InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!this.f_19853_.f_46443_) {
            Item heldItem;
            EntityType entityType;
            if (this.getDisplayedItem().m_41619_() && (entityType = (EntityType)ForgeRegistries.ENTITIES.getValue((heldItem = heldStack.m_41720_()).getRegistryName())) != EntityType.f_20510_ && AquacultureAPI.FISH_DATA.getFish().contains(heldItem)) {
                this.setDisplayedItem(heldStack);
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getPickedResult(HitResult target) {
        return !this.getDisplayedItem().m_41619_() ? this.getDisplayedItem() : new ItemStack((ItemLike)this.getItem());
    }

    protected void m_19915_(float yaw, float pitch) {
        super.m_19915_(yaw, pitch);
        if (pitch == 0.0f) {
            this.m_6022_(Direction.m_122364_((double)yaw));
        } else {
            this.m_6022_(pitch < 0.0f ? Direction.UP : Direction.DOWN);
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.m_6095_().getRegistryName());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }
}

