/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.init;

import com.google.common.collect.Lists;
import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.entity.SpectralWaterArrowEntity;
import com.teammetallurgy.aquaculture.entity.TurtleLandEntity;
import com.teammetallurgy.aquaculture.entity.WaterArrowEntity;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.misc.AquaConfig;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="aquaculture", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AquaEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_DEFERRED = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"aquaculture");
    private static final List<String> MOB_NAMES = Lists.newArrayList();
    public static final RegistryObject<EntityType<AquaFishingBobberEntity>> BOBBER = AquaEntities.register("bobber", () -> EntityType.Builder.m_20710_((MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(5).setCustomClientFactory(AquaFishingBobberEntity::new));
    public static final RegistryObject<EntityType<WaterArrowEntity>> WATER_ARROW = AquaEntities.register("water_arrow", () -> EntityType.Builder.m_20704_(WaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(WaterArrowEntity::new));
    public static final RegistryObject<EntityType<SpectralWaterArrowEntity>> SPECTRAL_WATER_ARROW = AquaEntities.register("spectral_water_arrow", () -> EntityType.Builder.m_20704_(SpectralWaterArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory(SpectralWaterArrowEntity::new));
    public static final RegistryObject<EntityType<TurtleLandEntity>> BOX_TURTLE = AquaEntities.registerMob("box_turtle", 1, 2, 10, BiomeDictionary.Type.SWAMP, null, 8356921, 6119722, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final RegistryObject<EntityType<TurtleLandEntity>> ARRAU_TURTLE = AquaEntities.registerMob("arrau_turtle", 1, 2, 8, BiomeDictionary.Type.JUNGLE, null, 7439738, 5202520, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));
    public static final RegistryObject<EntityType<TurtleLandEntity>> STARSHELL_TURTLE = AquaEntities.registerMob("starshell_turtle", 1, 2, 5, BiomeDictionaryHelper.TWILIGHT, null, 14476005, 0x464645, () -> EntityType.Builder.m_20704_(TurtleLandEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5f, 0.25f));

    private static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, int min, int max, int weight, BiomeDictionary.Type include, @Nullable BiomeDictionary.Type exclude, int eggPrimary, int eggSecondary, Supplier<EntityType.Builder<T>> builder) {
        return AquaEntities.registerMob(name, min, max, weight, eggPrimary, eggSecondary, Collections.singletonList(String.valueOf(include == null ? "" : include)), Collections.singletonList(String.valueOf(exclude == null ? "" : exclude)), builder);
    }

    private static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, int min, int max, int weight, int eggPrimary, int eggSecondary, List<? extends String> include, List<? extends String> exclude, Supplier<EntityType.Builder<T>> builder) {
        RegistryObject entityType = AquaEntities.register(name, builder);
        AquaItems.register(() -> new ForgeSpawnEggItem((Supplier)entityType, eggPrimary, eggSecondary, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)), name + "_spawn_egg");
        new AquaConfig.Spawn(AquaConfig.BUILDER, name, min, max, weight, include, exclude);
        MOB_NAMES.add(name);
        return entityType;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> builder) {
        ResourceLocation location = new ResourceLocation("aquaculture", name);
        return ENTITY_DEFERRED.register(name, () -> ((EntityType.Builder)builder.get()).m_20712_(location.toString()));
    }

    public static void setSpawnPlacement() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BOX_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ARRAU_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)STARSHELL_TURTLE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BOX_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
        event.put((EntityType)ARRAU_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
        event.put((EntityType)STARSHELL_TURTLE.get(), TurtleLandEntity.createAttributes().m_22265_());
    }

    public static void addEntitySpawns(BiomeLoadingEvent event) {
        for (String name : MOB_NAMES) {
            String subCategory = AquaConfig.Helper.getSubConfig("spawn options", name);
            BiomeDictionaryHelper.addSpawn((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("aquaculture", name)), (Integer)AquaConfig.Helper.get(subCategory, "min"), (Integer)AquaConfig.Helper.get(subCategory, "max"), (Integer)AquaConfig.Helper.get(subCategory, "weight"), (List)AquaConfig.Helper.get(subCategory, "include"), (List)AquaConfig.Helper.get(subCategory, "exclude"), event);
        }
    }
}

