/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.mixin;

import net.coderbot.batchedentityrendering.impl.DrawCallTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingRenderBuffers;
import net.coderbot.batchedentityrendering.impl.RenderBuffersExt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderBuffers.class})
public class MixinRenderBuffers
implements RenderBuffersExt,
MemoryTrackingRenderBuffers,
DrawCallTrackingRenderBuffers {
    @Unique
    private final FullyBufferedMultiBufferSource buffered = new FullyBufferedMultiBufferSource();
    @Unique
    private int begins = 0;
    @Unique
    private int maxBegins = 0;
    @Unique
    private final OutlineBufferSource outlineBufferSource = new OutlineBufferSource((MultiBufferSource.BufferSource)this.buffered);
    @Shadow
    @Final
    private MultiBufferSource.BufferSource f_110094_;

    @Inject(method={"bufferSource"}, at={@At(value="HEAD")}, cancellable=true)
    private void batchedentityrendering$replaceBufferSource(CallbackInfoReturnable<MultiBufferSource.BufferSource> cir) {
        if (this.begins == 0) {
            return;
        }
        cir.setReturnValue((Object)this.buffered);
    }

    @Inject(method={"crumblingBufferSource"}, at={@At(value="HEAD")}, cancellable=true)
    private void batchedentityrendering$replaceCrumblingBufferSource(CallbackInfoReturnable<MultiBufferSource.BufferSource> cir) {
        if (this.begins == 0) {
            return;
        }
        cir.setReturnValue((Object)this.buffered.getUnflushableWrapper());
    }

    @Inject(method={"outlineBufferSource"}, at={@At(value="HEAD")}, cancellable=true)
    private void batchedentityrendering$replaceOutlineBufferSource(CallbackInfoReturnable<OutlineBufferSource> provider) {
        if (this.begins == 0) {
            return;
        }
        provider.setReturnValue((Object)this.outlineBufferSource);
    }

    @Override
    public void beginLevelRendering() {
        if (this.begins == 0) {
            this.buffered.assertWrapStackEmpty();
        }
        ++this.begins;
        this.maxBegins = Math.max(this.begins, this.maxBegins);
    }

    @Override
    public void endLevelRendering() {
        --this.begins;
        if (this.begins == 0) {
            this.buffered.assertWrapStackEmpty();
        }
    }

    @Override
    public int getEntityBufferAllocatedSize() {
        return this.buffered.getAllocatedSize();
    }

    @Override
    public int getMiscBufferAllocatedSize() {
        return ((MemoryTrackingBuffer)this.f_110094_).getAllocatedSize();
    }

    @Override
    public int getMaxBegins() {
        return this.maxBegins;
    }

    @Override
    public int getDrawCalls() {
        return this.buffered.getDrawCalls();
    }

    @Override
    public int getRenderTypes() {
        return this.buffered.getRenderTypes();
    }

    @Override
    public void resetDrawCounts() {
        this.buffered.resetDrawCalls();
    }
}

