/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp;

import java.nio.ByteBuffer;
import net.coderbot.iris.vertices.QuadView;
import org.lwjgl.system.MemoryUtil;

public abstract class QuadViewEntity
implements QuadView {
    long writePointer;
    int stride;

    @Override
    public float x(int index) {
        return this.getFloat(this.writePointer - (long)this.stride * (3L - (long)index));
    }

    @Override
    public float y(int index) {
        return this.getFloat(this.writePointer + 4L - (long)this.stride * (3L - (long)index));
    }

    @Override
    public float z(int index) {
        return this.getFloat(this.writePointer + 8L - (long)this.stride * (3L - (long)index));
    }

    @Override
    public float u(int index) {
        return this.getFloat(this.writePointer + 16L - (long)this.stride * (3L - (long)index));
    }

    @Override
    public float v(int index) {
        return this.getFloat(this.writePointer + 20L - (long)this.stride * (3L - (long)index));
    }

    abstract float getFloat(long var1);

    public static class QuadViewEntityNio
    extends QuadViewEntity {
        private ByteBuffer buffer;

        public void setup(ByteBuffer buffer, int writePointer, int stride) {
            this.buffer = buffer;
            this.writePointer = writePointer;
            this.stride = stride;
        }

        @Override
        float getFloat(long writePointer) {
            return this.buffer.getFloat((int)writePointer);
        }
    }

    public static class QuadViewEntityUnsafe
    extends QuadViewEntity {
        public void setup(long writePointer, int stride) {
            this.writePointer = writePointer;
            this.stride = stride;
        }

        @Override
        float getFloat(long writePointer) {
            return MemoryUtil.memGetFloat((long)writePointer);
        }
    }
}

