/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.DepthColorStorage;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.ShaderInstanceInterface;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ShaderInstance.class})
public class MixinShaderInstance
implements ShaderInstanceInterface {
    @Unique
    private String lastSamplerName;
    @Unique
    private static final ImmutableSet<String> ATTRIBUTE_LIST = ImmutableSet.of((Object)"Position", (Object)"Color", (Object)"Normal", (Object)"UV0", (Object)"UV1", (Object)"UV2", (Object[])new String[0]);

    @Inject(method={"apply"}, at={@At(value="INVOKE", target="com/mojang/blaze3d/systems/RenderSystem.bindTexture (I)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void iris$beforeBindTexture(CallbackInfo ci, int lastActiveTexture, int textureUnit, String samplerName) {
        this.lastSamplerName = samplerName;
    }

    @Inject(method={"apply"}, at={@At(value="INVOKE", target="com/mojang/blaze3d/systems/RenderSystem.bindTexture (I)V", shift=At.Shift.AFTER)})
    private void iris$afterBindTexture(CallbackInfo ci) {
        String samplerName = Objects.requireNonNull(this.lastSamplerName);
        this.lastSamplerName = null;
        if (!(this instanceof ExtendedShader)) {
            return;
        }
        if (!((ExtendedShader)((Object)this)).isIntensitySwizzle()) {
            return;
        }
        if (samplerName.equals("Sampler0") || samplerName.equals("tex") || samplerName.equals("texture") || samplerName.equals("gtexture")) {
            IrisRenderSystem.texParameteriv(3553, 36422, new int[]{6403, 6403, 6403, 6403});
        }
    }

    @Redirect(method={"updateLocations"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"))
    private void iris$redirectLogSpam(Logger logger, String message, Object arg1, Object arg2) {
        if (this instanceof ExtendedShader || this instanceof FallbackShader) {
            return;
        }
        logger.warn(message, arg1, arg2);
    }

    @Redirect(method={"<init>(Lnet/minecraft/server/packs/resources/ResourceProvider;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/shaders/Uniform;glBindAttribLocation(IILjava/lang/CharSequence;)V"))
    public void iris$redirectBindAttributeLocation(int i, int j, CharSequence charSequence) {
        if (this instanceof ExtendedShader && ATTRIBUTE_LIST.contains((Object)charSequence)) {
            Uniform.m_166710_((int)i, (int)j, (CharSequence)("iris_" + charSequence));
        } else {
            Uniform.m_166710_((int)i, (int)j, (CharSequence)charSequence);
        }
    }

    @Inject(method={"apply"}, at={@At(value="TAIL")})
    private void iris$lockDepthColorState(CallbackInfo ci) {
        if (this instanceof ExtendedShader || this instanceof FallbackShader || !MixinShaderInstance.shouldOverrideShaders()) {
            return;
        }
        DepthColorStorage.disableDepthColor();
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")})
    private void iris$unlockDepthColorState(CallbackInfo ci) {
        if (this instanceof ExtendedShader || this instanceof FallbackShader || !MixinShaderInstance.shouldOverrideShaders()) {
            return;
        }
        DepthColorStorage.unlockDepthColor();
    }

    private static boolean shouldOverrideShaders() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof CoreWorldRenderingPipeline) {
            return ((CoreWorldRenderingPipeline)pipeline).shouldOverrideShaders();
        }
        return false;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void iris$setupGeometryShader(ResourceProvider resourceProvider, String string, VertexFormat vertexFormat, CallbackInfo ci) {
        this.iris$createGeometryShader(resourceProvider, new ResourceLocation(string));
    }

    @Inject(method={"<init>(Lnet/minecraft/server/packs/resources/ResourceProvider;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/VertexFormat;)V"}, at={@At(value="RETURN")})
    public void oculus$setupGeometryShader(ResourceProvider resourceProvider, ResourceLocation location, VertexFormat vertexFormat, CallbackInfo ci) {
        this.iris$createGeometryShader(resourceProvider, location);
    }

    @Override
    public void iris$createGeometryShader(ResourceProvider provider, ResourceLocation location) {
    }
}

