/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin.bettermipmaps;

import net.minecraft.client.renderer.texture.MipmapGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MipmapGenerator.class})
public class MixinMipmapGenerator {
    private static final float[] SRGB_TO_LINEAR = new float[256];

    @Overwrite
    private static int m_118048_(int one, int two, int three, int four, boolean checkAlpha) {
        return MixinMipmapGenerator.weightedAverageColor(MixinMipmapGenerator.weightedAverageColor(one, two), MixinMipmapGenerator.weightedAverageColor(three, four));
    }

    @Unique
    private static int unpackAlpha(int color) {
        return color >>> 24 & 0xFF;
    }

    @Unique
    private static int weightedAverageColor(int one, int two) {
        int alphaTwo;
        int alphaOne = MixinMipmapGenerator.unpackAlpha(one);
        if (alphaOne == (alphaTwo = MixinMipmapGenerator.unpackAlpha(two))) {
            return MixinMipmapGenerator.averageRgb(one, two, alphaOne);
        }
        if (alphaOne == 0) {
            return two & 0xFFFFFF | alphaTwo / 4 << 24;
        }
        if (alphaTwo == 0) {
            return one & 0xFFFFFF | alphaOne / 4 << 24;
        }
        float scale = 1.0f / (float)(alphaOne + alphaTwo);
        float relativeWeightOne = (float)alphaOne * scale;
        float relativeWeightTwo = (float)alphaTwo * scale;
        float oneR = MixinMipmapGenerator.unpackLinearComponent(one, 0) * relativeWeightOne;
        float oneG = MixinMipmapGenerator.unpackLinearComponent(one, 8) * relativeWeightOne;
        float oneB = MixinMipmapGenerator.unpackLinearComponent(one, 16) * relativeWeightOne;
        float twoR = MixinMipmapGenerator.unpackLinearComponent(two, 0) * relativeWeightTwo;
        float twoG = MixinMipmapGenerator.unpackLinearComponent(two, 8) * relativeWeightTwo;
        float twoB = MixinMipmapGenerator.unpackLinearComponent(two, 16) * relativeWeightTwo;
        float linearR = oneR + twoR;
        float linearG = oneG + twoG;
        float linearB = oneB + twoB;
        int averageAlpha = (alphaOne + alphaTwo) / 2;
        return MixinMipmapGenerator.packLinearToSrgb(linearR, linearG, linearB, averageAlpha);
    }

    @Unique
    private static float unpackLinearComponent(int color, int shift) {
        return SRGB_TO_LINEAR[color >> shift & 0xFF];
    }

    @Unique
    private static int packLinearToSrgb(float r, float g, float b, int a) {
        int srgbR = (int)(Math.pow(r, 0.45454545454545453) * 255.0);
        int srgbG = (int)(Math.pow(g, 0.45454545454545453) * 255.0);
        int srgbB = (int)(Math.pow(b, 0.45454545454545453) * 255.0);
        return a << 24 | srgbB << 16 | srgbG << 8 | srgbR;
    }

    @Unique
    private static int averageRgb(int a, int b, int alpha) {
        float ar = MixinMipmapGenerator.unpackLinearComponent(a, 0);
        float ag = MixinMipmapGenerator.unpackLinearComponent(a, 8);
        float ab = MixinMipmapGenerator.unpackLinearComponent(a, 16);
        float br = MixinMipmapGenerator.unpackLinearComponent(b, 0);
        float bg = MixinMipmapGenerator.unpackLinearComponent(b, 8);
        float bb = MixinMipmapGenerator.unpackLinearComponent(b, 16);
        return MixinMipmapGenerator.packLinearToSrgb((ar + br) / 2.0f, (ag + bg) / 2.0f, (ab + bb) / 2.0f, alpha);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MixinMipmapGenerator.SRGB_TO_LINEAR[i] = (float)Math.pow((double)i / 255.0, 2.2);
        }
    }
}

