/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;

public final class CelestialUniforms {
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", CelestialUniforms::getSunAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    public static float getSunAngle() {
        float skyAngle = CelestialUniforms.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(-100.0f);
    }

    public Vector4f getShadowLightPosition() {
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(100.0f) : this.getCelestialPositionInWorldSpace(-100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(float y) {
        com.mojang.math.Vector4f position = new com.mojang.math.Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f();
        celestial.m_27624_();
        celestial.m_27646_(Vector3f.f_122225_.m_122240_(-90.0f));
        celestial.m_27646_(Vector3f.f_122227_.m_122240_(this.sunPathRotation));
        celestial.m_27646_(Vector3f.f_122223_.m_122240_(CelestialUniforms.getSkyAngle() * 360.0f));
        position.m_123607_(celestial);
        return JomlConversions.toJoml(position);
    }

    private Vector4f getCelestialPosition(float y) {
        com.mojang.math.Vector4f position = new com.mojang.math.Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = CapturedRenderingState.INSTANCE.getGbufferModelView().m_27658_();
        celestial.m_27646_(Vector3f.f_122225_.m_122240_(-90.0f));
        celestial.m_27646_(Vector3f.f_122227_.m_122240_(this.sunPathRotation));
        celestial.m_27646_(Vector3f.f_122223_.m_122240_(CelestialUniforms.getSkyAngle() * 360.0f));
        position.m_123607_(celestial);
        return JomlConversions.toJoml(position);
    }

    private static Vector4f getUpPosition() {
        com.mojang.math.Vector4f upVector = new com.mojang.math.Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f preCelestial = CapturedRenderingState.INSTANCE.getGbufferModelView().m_27658_();
        preCelestial.m_27646_(Vector3f.f_122225_.m_122240_(-90.0f));
        upVector.m_123607_(preCelestial);
        return JomlConversions.toJoml(upVector);
    }

    public static boolean isDay() {
        return (double)CelestialUniforms.getSunAngle() <= 0.5;
    }

    private static ClientLevel getWorld() {
        return Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
    }

    private static float getSkyAngle() {
        return CelestialUniforms.getWorld().m_46942_(CapturedRenderingState.INSTANCE.getTickDelta());
    }
}

