/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.client;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import com.chaosthedude.naturescompass.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player;
        ItemStack stack;
        if (event.phase == TickEvent.Phase.END && ClientEventHandler.mc.f_91074_ != null && ClientEventHandler.mc.f_91073_ != null && !ClientEventHandler.mc.f_91066_.f_92062_ && !ClientEventHandler.mc.f_91066_.f_92063_ && (ClientEventHandler.mc.f_91080_ == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ClientEventHandler.mc.f_91080_ instanceof ChatScreen) && (stack = ItemUtils.getHeldNatureCompass((Player)(player = ClientEventHandler.mc.f_91074_))) != null && stack.m_41720_() instanceof NaturesCompassItem) {
            PoseStack poseStack = new PoseStack();
            NaturesCompassItem compass = (NaturesCompassItem)stack.m_41720_();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, BiomeUtils.getBiomeName((Level)ClientEventHandler.mc.f_91073_, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, BiomeUtils.getBiomeName((Level)ClientEventHandler.mc.f_91073_, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                    RenderUtils.drawConfiguredStringOnHUD(poseStack, compass.getFoundBiomeX(stack) + ", " + compass.getFoundBiomeZ(stack), 5, 5, 0xAAAAAA, 7);
                    RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                    RenderUtils.drawConfiguredStringOnHUD(poseStack, String.valueOf(BiomeUtils.getDistanceToBiome((Player)player, compass.getFoundBiomeX(stack), compass.getFoundBiomeZ(stack))), 5, 5, 0xAAAAAA, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.biome", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, BiomeUtils.getBiomeName((Level)ClientEventHandler.mc.f_91073_, compass.getBiomeKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, I18n.m_118938_((String)"string.naturescompass.samples", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                RenderUtils.drawConfiguredStringOnHUD(poseStack, String.valueOf(compass.getSamples(stack)), 5, 5, 0xAAAAAA, 10);
            }
        }
    }
}

