/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.WorldWorkerManager;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    public final int sampleSpace;
    public final int maxSamples;
    public final int maxRadius;
    public Level level;
    public Biome biome;
    public ResourceLocation biomeKey;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public Direction direction;
    public ItemStack stack;
    public Player player;
    public int x;
    public int y;
    public int z;
    public int length;
    public boolean finished;
    public int lastRadiusThreshold;

    public BiomeSearchWorker(Level level, Player player, ItemStack stack, Biome biome, BlockPos startPos) {
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.biome = biome;
        this.startPos = startPos;
        this.x = startPos.m_123341_();
        this.y = startPos.m_123342_();
        this.z = startPos.m_123343_();
        this.sampleSpace = (Integer)ConfigHandler.GENERAL.sampleSpaceModifier.get() * BiomeUtils.getBiomeSize(level);
        this.maxSamples = (Integer)ConfigHandler.GENERAL.maxSamples.get();
        this.maxRadius = (Integer)ConfigHandler.GENERAL.radiusModifier.get() * BiomeUtils.getBiomeSize(level);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.finished = false;
        this.biomeKey = BiomeUtils.getKeyForBiome(level, biome).isPresent() ? BiomeUtils.getKeyForBiome(level, biome).get() : null;
        this.lastRadiusThreshold = 0;
    }

    public void start() {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == NaturesCompass.naturesCompass) {
            if (this.maxRadius > 0 && this.sampleSpace > 0) {
                NaturesCompass.LOGGER.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxSamples + " max samples, " + this.maxRadius + " max radius");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(false);
            }
        }
    }

    public boolean hasWork() {
        return this.biomeKey != null && !this.finished && this.getRadius() <= this.maxRadius && this.samples <= this.maxSamples;
    }

    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                this.z -= this.sampleSpace;
            } else if (this.direction == Direction.EAST) {
                this.x += this.sampleSpace;
            } else if (this.direction == Direction.SOUTH) {
                this.z += this.sampleSpace;
            } else if (this.direction == Direction.WEST) {
                this.x -= this.sampleSpace;
            }
            Biome biomeAtPos = (Biome)this.level.m_7062_().m_204216_(new BlockPos(this.x, this.y, this.z)).m_203334_();
            Optional<ResourceLocation> optionalBiomeAtPosKey = BiomeUtils.getKeyForBiome(this.level, biomeAtPos);
            if (optionalBiomeAtPosKey.isPresent() && optionalBiomeAtPosKey.get().equals((Object)this.biomeKey)) {
                this.finish(true);
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.m_122427_();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 500 && radius / 500 > this.lastRadiusThreshold) {
                if (!this.stack.m_41619_() && this.stack.m_41720_() == NaturesCompass.naturesCompass) {
                    ((NaturesCompassItem)this.stack.m_41720_()).setSearchRadius(this.stack, this.roundRadius(radius, 500), this.player);
                }
                this.lastRadiusThreshold = radius / 500;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == NaturesCompass.naturesCompass) {
            if (found) {
                NaturesCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.m_41720_()).setFound(this.stack, this.x, this.z, this.samples, this.player);
                ((NaturesCompassItem)this.stack.m_41720_()).setDisplayCoordinates(this.stack, (Boolean)ConfigHandler.GENERAL.displayCoordinates.get());
            } else {
                NaturesCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((NaturesCompassItem)this.stack.m_41720_()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 500), this.samples);
            }
        } else {
            NaturesCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return BiomeUtils.getDistanceToBiome(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }
}

