/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.AdvancementsProvider;
import slimeknights.tconstruct.common.data.loot.GlobalLootModifiersProvider;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BiomeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockEntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.plugin.ImmersiveEngineeringPlugin;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod(value="tconstruct")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TConstruct {
    public static final String MOD_ID = "tconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"tconstruct");
    public static final Random RANDOM = new Random();
    public static TConstruct instance;

    public TConstruct() {
        instance = this;
        Config.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)new TinkerCommons());
        bus.register((Object)new TinkerMaterials());
        bus.register((Object)new TinkerFluids());
        bus.register((Object)new TinkerGadgets());
        bus.register((Object)new TinkerWorld());
        bus.register((Object)new TinkerStructures());
        bus.register((Object)new TinkerTables());
        bus.register((Object)new TinkerModifiers());
        bus.register((Object)new TinkerToolParts());
        bus.register((Object)new TinkerTools());
        bus.register((Object)new TinkerSmeltery());
        TinkerModule.initRegisters();
        TinkerNetwork.setup();
        TinkerTags.init();
        TinkerBookIDs.registerCommandSuggestion();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TinkerClient::onConstruct);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (ModList.get().isLoaded("immersiveengineering")) {
            bus.register((Object)new ImmersiveEngineeringPlugin());
        }
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MaterialRegistry.init();
        ToolDefinitionLoader.init();
        StationSlotLayoutLoader.init();
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            BlockTagProvider blockTags = new BlockTagProvider(datagenerator, existingFileHelper);
            datagenerator.m_123914_((DataProvider)blockTags);
            datagenerator.m_123914_((DataProvider)new ItemTagProvider(datagenerator, blockTags, existingFileHelper));
            datagenerator.m_123914_((DataProvider)new FluidTagProvider(datagenerator, existingFileHelper));
            datagenerator.m_123914_((DataProvider)new EntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.m_123914_((DataProvider)new BlockEntityTypeTagProvider(datagenerator, existingFileHelper));
            datagenerator.m_123914_((DataProvider)new TConstructLootTableProvider(datagenerator));
            datagenerator.m_123914_((DataProvider)new AdvancementsProvider(datagenerator));
            datagenerator.m_123914_((DataProvider)new BiomeTagProvider(datagenerator, existingFileHelper));
            datagenerator.m_123914_((DataProvider)new GlobalLootModifiersProvider(datagenerator));
        }
    }

    @Nullable
    private static Block missingBlock(String name) {
        return switch (name) {
            case "copper_block" -> Blocks.f_152504_;
            case "copper_ore" -> Blocks.f_152505_;
            case "tinkers_bronze_block" -> (Block)TinkerMaterials.amethystBronze.get();
            case "molten_tinkers_bronze_fluid" -> TinkerFluids.moltenAmethystBronze.getBlock();
            default -> null;
        };
    }

    @SubscribeEvent
    void missingItems(RegistryEvent.MissingMappings<Item> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> {
            switch (name) {
                case "copper_ingot": {
                    return Items.f_151052_;
                }
                case "blank_cast": {
                    return Items.f_42417_;
                }
                case "pickaxe_head": {
                    return (Item)TinkerToolParts.pickHead.get();
                }
                case "pickaxe_head_cast": {
                    return (Item)TinkerSmeltery.pickHeadCast.get();
                }
                case "pickaxe_head_sand_cast": {
                    return TinkerSmeltery.pickHeadCast.getSand();
                }
                case "pickaxe_head_red_sand_cast": {
                    return TinkerSmeltery.pickHeadCast.getRedSand();
                }
                case "tinkers_bronze_ingot": {
                    TinkerMaterials.amethystBronze.getIngot();
                }
                case "tinkers_bronze_nugget": {
                    TinkerMaterials.amethystBronze.getNugget();
                }
                case "molten_tinkers_bronze_bucket": {
                    return TinkerFluids.moltenAmethystBronze.m_5456_();
                }
                case "flint_and_bronze": {
                    TinkerTools.flintAndBrick.get();
                }
            }
            Block block = TConstruct.missingBlock(name);
            return block == null ? null : block.m_5456_();
        });
    }

    @SubscribeEvent
    void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, TConstruct::missingBlock);
    }

    @SubscribeEvent
    void missingFluid(RegistryEvent.MissingMappings<Fluid> event) {
        RegistrationHelper.handleMissingMappings(event, (String)MOD_ID, name -> switch (name) {
            case "molten_tinkers_bronze" -> TinkerFluids.moltenAmethystBronze.get();
            case "flowing_molten_tinkers_bronze" -> TinkerFluids.moltenAmethystBronze.getFlowing();
            default -> null;
        });
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of(TConstruct.getResource(name));
    }

    public static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of(TConstruct.getResource(name), constructor);
    }

    public static String resourceString(String res) {
        return String.format("%s:%s", MOD_ID, res);
    }

    public static String prefix(String name) {
        return String.format("%s.%s", MOD_ID, name.toLowerCase(Locale.US));
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey(base, TConstruct.getResource(name));
    }

    public static MutableComponent makeTranslation(String base, String name) {
        return new TranslatableComponent(TConstruct.makeTranslationKey(base, name));
    }

    public static MutableComponent makeTranslation(String base, String name, Object ... arguments) {
        return new TranslatableComponent(TConstruct.makeTranslationKey(base, name), arguments);
    }
}

