/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.tconstruct.library.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.tconstruct.library.fluid.transfer.FluidContainerTransferManager;
import slimeknights.tconstruct.library.fluid.transfer.IFluidContainerTransfer;

public abstract class AbstractFluidContainerTransferProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, IFluidContainerTransfer> allTransfers = new HashMap<ResourceLocation, IFluidContainerTransfer>();
    private final String modId;

    public AbstractFluidContainerTransferProvider(DataGenerator generator, String modId) {
        super(generator, PackType.SERVER_DATA, "tinkering/fluid_transfer", FluidContainerTransferManager.GSON);
        this.modId = modId;
    }

    protected abstract void addTransfers();

    protected void addTransfer(ResourceLocation id, IFluidContainerTransfer transfer) {
        IFluidContainerTransfer previous = this.allTransfers.putIfAbsent(id, transfer);
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate fluid container transfer " + id);
        }
    }

    protected void addTransfer(String name, IFluidContainerTransfer transfer) {
        this.addTransfer(new ResourceLocation(this.modId, name), transfer);
    }

    protected void addFillEmpty(String prefix, ItemLike item, ItemLike container, Fluid fluid, TagKey<Fluid> tag, int amount) {
        this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), ItemOutput.fromItem((ItemLike)container), new FluidStack(fluid, amount)));
        this.addTransfer(prefix + "fill", (IFluidContainerTransfer)new FillFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{container}), ItemOutput.fromItem((ItemLike)item), FluidIngredient.of(tag, (int)amount)));
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addTransfers();
        this.allTransfers.forEach((id, data) -> this.saveThing(cache, (ResourceLocation)id, data));
    }
}

