/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.transfer.FluidContainerTransferManager;
import slimeknights.tconstruct.library.fluid.transfer.IFluidContainerTransfer;

public class FluidTransferUtil {
    private static final String KEY_FILLED = TConstruct.makeTranslationKey("block", "tank.filled");
    private static final String KEY_DRAINED = TConstruct.makeTranslationKey("block", "tank.drained");

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, int maxFill) {
        int simulatedFill;
        FluidStack simulated = input.drain(maxFill, IFluidHandler.FluidAction.SIMULATE);
        if (!simulated.isEmpty() && (simulatedFill = output.fill(simulated, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            int actualFill;
            FluidStack drainedFluid = input.drain(simulatedFill, IFluidHandler.FluidAction.EXECUTE);
            if (!drainedFluid.isEmpty() && (actualFill = output.fill(drainedFluid.copy(), IFluidHandler.FluidAction.EXECUTE)) != drainedFluid.getAmount()) {
                TConstruct.LOG.error("Lost {} fluid during transfer", (Object)(drainedFluid.getAmount() - actualFill));
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }

    public static boolean interactWithBucket(Level world, BlockPos pos, Player player, InteractionHand hand, Direction hit, Direction offset) {
        BucketItem bucket;
        Fluid fluid;
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof BucketItem && (fluid = (bucket = (BucketItem)item).getFluid()) != Fluids.f_76191_) {
            BlockEntity te;
            if (!world.f_46443_ && (te = world.m_7702_(pos)) != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit).ifPresent(handler -> {
                    FluidStack fluidStack = new FluidStack(bucket.getFluid(), 1000);
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        bucket.m_142131_(player, world, held, pos.m_142300_(offset));
                        world.m_5594_(null, pos, fluid.getAttributes().getEmptySound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        player.m_5661_((Component)new TranslatableComponent(KEY_FILLED, new Object[]{1000, fluidStack.getDisplayName()}), true);
                        if (!player.m_7500_()) {
                            player.m_21008_(hand, held.getContainerItem());
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static void playEmptySound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, transferred.getFluid().getAttributes().getEmptySound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)new TranslatableComponent(KEY_FILLED, new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    private static void playFillSound(Level world, BlockPos pos, Player player, FluidStack transferred) {
        world.m_5594_(null, pos, transferred.getFluid().getAttributes().getFillSound(transferred), SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_5661_((Component)new TranslatableComponent(KEY_DRAINED, new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
    }

    public static boolean interactWithFluidItem(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        LazyOptional teCapability;
        BlockEntity te;
        ItemStack stack = player.m_21120_(hand);
        Direction face = hit.m_82434_();
        if (!stack.m_41619_() && (te = world.m_7702_(pos)) != null && (teCapability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face)).isPresent()) {
            IFluidHandler teHandler = (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE);
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (itemCapability.isPresent()) {
                if (!world.f_46443_) {
                    IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                    FluidStack transferred = FluidTransferUtil.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                    if (!transferred.isEmpty()) {
                        FluidTransferUtil.playEmptySound(world, pos, player, transferred);
                    } else {
                        transferred = FluidTransferUtil.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                        if (!transferred.isEmpty()) {
                            FluidTransferUtil.playFillSound(world, pos, player, transferred);
                        }
                    }
                    if (!transferred.isEmpty()) {
                        player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)itemHandler.getContainer()));
                    }
                }
                return true;
            }
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack)) {
                IFluidContainerTransfer.TransferResult result;
                FluidStack currentFluid;
                IFluidContainerTransfer transfer;
                if (!world.f_46443_ && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler)) != null) {
                    if (result.didFill()) {
                        FluidTransferUtil.playFillSound(world, pos, player, result.fluid());
                    } else {
                        FluidTransferUtil.playEmptySound(world, pos, player, result.fluid());
                    }
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)result.stack()));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean interactWithTank(Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return FluidTransferUtil.interactWithFluidItem(world, pos, player, hand, hit) || FluidTransferUtil.interactWithBucket(world, pos, player, hand, hit.m_82434_(), hit.m_82434_());
    }

    private FluidTransferUtil() {
    }
}

