/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid.transfer;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.fluid.transfer.IFluidContainerTransfer;

public class EmptyFluidContainerTransfer
implements IFluidContainerTransfer {
    public static final ResourceLocation ID = TConstruct.getResource("empty_item");
    private final Ingredient input;
    private final ItemOutput filled;
    private final FluidStack fluid;
    public static final JsonDeserializer<EmptyFluidContainerTransfer> DESERIALIZER = (element, typeOfT, context) -> {
        JsonObject json = element.getAsJsonObject();
        Ingredient input = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"input"));
        ItemOutput filled = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"filled"));
        FluidStack fluid = RecipeHelper.deserializeFluidStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        return new EmptyFluidContainerTransfer(input, filled, fluid);
    };

    @Override
    public void addRepresentativeItems(Consumer<Item> consumer) {
        for (ItemStack stack : this.input.m_43908_()) {
            consumer.accept(stack.m_41720_());
        }
    }

    @Override
    public boolean matches(ItemStack stack, FluidStack fluid) {
        return this.input.test(stack);
    }

    @Override
    public IFluidContainerTransfer.TransferResult transfer(ItemStack stack, FluidStack fluid, IFluidHandler handler) {
        int actual;
        int simulated = handler.fill(this.fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
        if (simulated == this.fluid.getAmount() && (actual = handler.fill(this.fluid.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
            if (actual != this.fluid.getAmount()) {
                TConstruct.LOG.error("Wrong amount filled from {}, expected {}, filled {}", (Object)stack.m_41720_().getRegistryName(), (Object)this.fluid.getAmount(), (Object)actual);
            }
            return new IFluidContainerTransfer.TransferResult(this.filled.get().m_41777_(), this.fluid, false);
        }
        return null;
    }

    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        json.add("input", this.input.m_43942_());
        json.add("filled", this.filled.serialize());
        json.add("fluid", (JsonElement)RecipeHelper.serializeFluidStack((FluidStack)this.fluid));
        return json;
    }

    public EmptyFluidContainerTransfer(Ingredient input, ItemOutput filled, FluidStack fluid) {
        this.input = input;
        this.filled = filled;
        this.fluid = fluid;
    }
}

