/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class MobDisguiseModifier
extends NoLevelsModifier {
    public static final GenericLoaderRegistry.IGenericLoader<MobDisguiseModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<MobDisguiseModifier>(){

        public MobDisguiseModifier deserialize(JsonObject json) {
            return new MobDisguiseModifier((EntityType)JsonUtils.getAsEntry(ForgeRegistries.ENTITIES, json, "entity"));
        }

        public void serialize(MobDisguiseModifier object, JsonObject json) {
            json.addProperty("entity", Objects.requireNonNull(object.type.getRegistryName()).toString());
        }

        public MobDisguiseModifier fromNetwork(FriendlyByteBuf buffer) {
            return new MobDisguiseModifier((EntityType)buffer.readRegistryIdUnsafe(ForgeRegistries.ENTITIES));
        }

        public void toNetwork(MobDisguiseModifier object, FriendlyByteBuf buffer) {
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, object.type);
        }
    };
    public static final TinkerDataCapability.TinkerDataKey<Multiset<EntityType<?>>> DISGUISES = TConstruct.createKey("mob_disguise");
    private final EntityType<?> type;

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                HashMultiset disguises = data.get(DISGUISES);
                if (disguises == null) {
                    disguises = HashMultiset.create();
                    data.put(DISGUISES, disguises);
                }
                disguises.add(this.type);
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            context.getTinkerData().ifPresent(data -> {
                Multiset<EntityType<?>> disguises = data.get(DISGUISES);
                if (disguises != null) {
                    disguises.remove(this.type);
                }
            });
        }
    }

    public MobDisguiseModifier(EntityType<?> type) {
        this.type = type;
    }
}

