/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class ToolBuildingRecipe
implements ITinkerStationRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final IModifiable output;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.toolBuildingRecipeSerializer.get();
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level worldIn) {
        int i;
        if (!inv.getTinkerableStack().m_41619_()) {
            return false;
        }
        List<PartRequirement> parts = this.output.getToolDefinition().getData().getParts();
        if (parts.isEmpty()) {
            return false;
        }
        for (i = 0; i < parts.size(); ++i) {
            if (parts.get(i).matches(inv.getInput(i).m_41720_())) continue;
            return false;
        }
        while (i < inv.getInputCount()) {
            if (!inv.getInput(i).m_41619_()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ItemStack assemble(ITinkerStationContainer inv) {
        List<MaterialVariant> materials = IntStream.range(0, this.output.getToolDefinition().getData().getParts().size()).mapToObj(i -> MaterialVariant.of(IMaterialItem.getMaterialFromStack(inv.getInput(i)))).toList();
        return ToolBuildHandler.buildItemFromMaterials(this.output, new MaterialNBT(materials));
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.output);
    }

    public ToolBuildingRecipe(ResourceLocation id, String group, IModifiable output) {
        this.id = id;
        this.group = group;
        this.output = output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }
}

