/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.DefinitionModifierSlots;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.UpdateToolDefinitionDataPacket;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.weapon.IWeaponAttack;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ToolDefinitionLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ToolDefinitionLoader.class);
    public static final String FOLDER = "tinkering/tool_definitions";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(StatsNBT.class, (Object)StatsNBT.SERIALIZER).registerTypeAdapter(MultiplierNBT.class, (Object)MultiplierNBT.SERIALIZER).registerTypeAdapter(PartRequirement.class, (Object)PartRequirement.SERIALIZER).registerTypeAdapter(DefinitionModifierSlots.class, (Object)DefinitionModifierSlots.SERIALIZER).registerTypeAdapter(ModifierEntry.class, (Object)ModifierEntry.SERIALIZER).registerTypeAdapter(ToolAction.class, (Object)ToolActionSerializer.INSTANCE).registerTypeHierarchyAdapter(IAreaOfEffectIterator.class, IAreaOfEffectIterator.LOADER).registerTypeHierarchyAdapter(IHarvestLogic.class, IHarvestLogic.LOADER).registerTypeHierarchyAdapter(IWeaponAttack.class, IWeaponAttack.LOADER).setPrettyPrinting().disableHtmlEscaping().create();
    private static final ToolDefinitionLoader INSTANCE = new ToolDefinitionLoader();
    private Map<ResourceLocation, ToolDefinitionData> dataMap = Collections.emptyMap();
    private final Map<ResourceLocation, ToolDefinition> definitions = new HashMap<ResourceLocation, ToolDefinition>();

    private ToolDefinitionLoader() {
        super(GSON, FOLDER);
    }

    public static ToolDefinitionLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::onDatapackSync);
    }

    protected void updateDataFromServer(Map<ResourceLocation, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ToolDefinitionData data = dataMap.get(entry.getKey());
            ToolDefinition definition = entry.getValue();
            if (data != null) {
                definition.setData(data);
                continue;
            }
            definition.setDefaultData();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ResourceLocation key = entry.getKey();
            ToolDefinition definition = entry.getValue();
            JsonElement element = splashList.get(key);
            if (element == null) {
                log.error("Missing tool definition for tool {}", (Object)key);
                definition.setDefaultData();
                continue;
            }
            try {
                ToolDefinitionData data = (ToolDefinitionData)GSON.fromJson((JsonElement)GsonHelper.m_13918_((JsonElement)element, (String)"tool_definition"), ToolDefinitionData.class);
                definition.validate(data);
                builder.put((Object)key, (Object)data);
                definition.setData(data);
            }
            catch (Exception e) {
                log.error("Failed to load tool definition for tool {}", (Object)key, (Object)e);
                definition.setDefaultData();
            }
        }
        this.dataMap = builder.build();
        log.info("Loaded {} tool definitions in {} ms", (Object)this.dataMap.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public Collection<ToolDefinition> getRegisteredToolDefinitions() {
        return this.definitions.values();
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        UpdateToolDefinitionDataPacket packet = new UpdateToolDefinitionDataPacket(this.dataMap);
        TinkerNetwork.getInstance().sendToPlayerList(event.getPlayer(), event.getPlayerList(), packet);
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }

    public void registerToolDefinition(ToolDefinition definition) {
        ResourceLocation name = definition.getId();
        if (this.definitions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate tool definition " + name);
        }
        this.definitions.put(name, definition);
    }

    private static enum ToolActionSerializer implements JsonSerializer<ToolAction>,
    JsonDeserializer<ToolAction>
    {
        INSTANCE;


        public ToolAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ToolAction.get((String)GsonHelper.m_13805_((JsonElement)json, (String)"action"));
        }

        public JsonElement serialize(ToolAction src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }
}

