/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.tconstruct.common.ClientEventBase;
import slimeknights.tconstruct.library.client.ResourceColorManager;
import slimeknights.tconstruct.library.client.book.TinkerBook;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.client.FluidParticle;

@Mod.EventBusSubscriber(modid="tconstruct", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonsClientEvents
extends ClientEventBase {
    private static Font unicodeRenderer;

    @SubscribeEvent
    static void addResourceListeners(RegisterClientReloadListenersEvent event) {
        MaterialRenderInfoLoader.addResourceListener(event);
        DomainDisplayName.addResourceListener(event);
        ResourceColorManager.init(event);
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        Font unicode;
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.glow.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.clearGlass.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.clearGlassPane.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.clearTintedGlass.get()), (RenderType)RenderType.m_110466_());
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.clearStainedGlass.get((Enum)color)), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.clearStainedGlassPane.get((Enum)color)), (RenderType)RenderType.m_110466_());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.soulGlass.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.soulGlassPane.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerMaterials.soulsteel.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerMaterials.slimesteel.get()), (RenderType)RenderType.m_110466_());
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.goldBars.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.goldPlatform.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.ironPlatform.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TinkerCommons.cobaltPlatform.get()), (RenderType)cutout);
        Consumer<Block> setCutout = block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)cutout);
        TinkerCommons.copperPlatform.forEach(setCutout);
        TinkerCommons.waxedCopperPlatform.forEach(setCutout);
        TinkerBook.MATERIALS_AND_YOU.fontRenderer = unicode = CommonsClientEvents.unicodeFontRender();
        TinkerBook.TINKERS_GADGETRY.fontRenderer = unicode;
        TinkerBook.PUNY_SMELTING.fontRenderer = unicode;
        TinkerBook.MIGHTY_SMELTING.fontRenderer = unicode;
        TinkerBook.FANTASTIC_FOUNDRY.fontRenderer = unicode;
        TinkerBook.ENCYCLOPEDIA.fontRenderer = unicode;
    }

    @SubscribeEvent
    static void registerColorHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            Block block = (Block)TinkerCommons.clearStainedGlass.get((Enum)color);
            Block pane = (Block)TinkerCommons.clearStainedGlassPane.get((Enum)color);
            blockColors.m_92589_((state, reader, pos, index) -> color.getColor(), new Block[]{block, pane});
            CommonsClientEvents.registerBlockItemColorAlias(blockColors, itemColors, block);
            CommonsClientEvents.registerBlockItemColorAlias(blockColors, itemColors, pane);
        }
    }

    @SubscribeEvent
    static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107381_((ParticleType)TinkerCommons.fluidParticle.get(), (ParticleProvider)new FluidParticle.Factory());
    }

    public static Font unicodeFontRender() {
        if (unicodeRenderer == null) {
            unicodeRenderer = new Font(rl -> {
                FontManager resourceManager = Minecraft.m_91087_().f_91045_;
                return (FontSet)resourceManager.f_94999_.get(Minecraft.f_91058_);
            });
        }
        return unicodeRenderer;
    }
}

