/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;

public class HeldModifiableItemIterator {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "held_modifiable.failed"));
    private static final DynamicCommandExceptionType NONLIVING_ENTITY_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.nonliving", error));
    private static final DynamicCommandExceptionType ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.no_item", error));
    private static final DynamicCommandExceptionType INVALID_ITEM = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.invalid_item", error));

    public static List<LivingEntity> apply(CommandContext<CommandSourceStack> context, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        return HeldModifiableItemIterator.apply(EntityArgument.m_91461_(context, (String)"targets"), behavior);
    }

    public static List<LivingEntity> apply(Collection<? extends Entity> targets, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        ArrayList<LivingEntity> successes = new ArrayList<LivingEntity>();
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.m_21205_();
                if (!stack.m_41619_()) {
                    if (stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                        if (!behavior.accept(living, stack)) continue;
                        successes.add(living);
                        continue;
                    }
                    throw INVALID_ITEM.create((Object)entity.m_7755_().getString());
                }
                throw ITEMLESS_EXCEPTION.create((Object)entity.m_7755_().getString());
            }
            throw NONLIVING_ENTITY_EXCEPTION.create((Object)entity.m_7755_().getString());
        }
        if (successes.isEmpty()) {
            throw FAILED_EXCEPTION.create();
        }
        return successes;
    }

    public static interface HeldModifiableBehavior {
        public boolean accept(LivingEntity var1, ItemStack var2) throws CommandSyntaxException;
    }
}

