/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;

public class ModifierArgument
implements ArgumentType<Modifier> {
    private static final Collection<String> EXAMPLES = Arrays.asList("tconstruct:haste", "tconstruct:luck");
    private static final DynamicCommandExceptionType MODIFIER_NOT_FOUND = new DynamicCommandExceptionType(name -> TConstruct.makeTranslation("command", "modifier.not_found", name));

    public Modifier parse(StringReader reader) throws CommandSyntaxException {
        ModifierId loc = new ModifierId(ResourceLocation.m_135818_((StringReader)reader));
        if (!ModifierManager.INSTANCE.contains(loc)) {
            throw MODIFIER_NOT_FOUND.create((Object)loc);
        }
        return ModifierManager.getValue(loc);
    }

    public static Modifier getModifier(CommandContext<CommandSourceStack> context, String name) {
        return (Modifier)context.getArgument(name, Modifier.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(ModifierManager.INSTANCE.getAllLocations(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private ModifierArgument() {
    }

    public static ModifierArgument modifier() {
        return new ModifierArgument();
    }
}

