/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.data;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.world.TinkerWorld;

public class CommonRecipeProvider
extends BaseRecipeProvider
implements ICommonRecipeHelper {
    public CommonRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Common Recipes";
    }

    @Override
    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addCommonRecipes(consumer);
        this.addMaterialRecipes(consumer);
    }

    private void addCommonRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "common/firewood/";
        this.slabStairsCrafting(consumer, TinkerCommons.blazewood, folder, false);
        this.slabStairsCrafting(consumer, TinkerCommons.lavawood, folder, false);
        this.slabStairsCrafting(consumer, (BuildingBlockObject)TinkerMaterials.nahuatl, folder, false);
        ShapedRecipeBuilder.m_126118_((ItemLike)TinkerMaterials.nahuatl.getFence(), (int)6).m_126130_("WWW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)TinkerMaterials.nahuatl).m_142284_("has_planks", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)TinkerMaterials.nahuatl)).m_142700_(consumer, this.modResource(folder + "nahuatl_fence"));
        this.slabStairsCrafting(consumer, TinkerCommons.mudBricks, "common/", false);
        ShapedRecipeBuilder.m_126118_(TinkerCommons.goldBars, (int)16).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_126130_("###").m_126130_("###").m_142284_("has_ingot", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_142700_(consumer, this.modResource("common/gold_bars"));
        ShapedRecipeBuilder.m_126118_(TinkerCommons.goldPlatform, (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('.'), Tags.Items.NUGGETS_GOLD).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_142284_("has_gold", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_142700_(consumer, this.modResource("common/gold_platform"));
        ShapedRecipeBuilder.m_126118_(TinkerCommons.ironPlatform, (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('.'), Tags.Items.NUGGETS_IRON).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_142284_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_142700_(consumer, this.modResource("common/iron_platform"));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)TinkerCommons.copperPlatform.get((Enum)WeatheringCopper.WeatherState.UNAFFECTED)), (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('.'), TinkerTags.Items.NUGGETS_COPPER).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_142284_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_142700_(consumer, this.modResource("common/copper_platform"));
        ShapedRecipeBuilder.m_126118_(TinkerCommons.cobaltPlatform, (int)4).m_206416_(Character.valueOf('#'), TinkerMaterials.cobalt.getIngotTag()).m_206416_(Character.valueOf('.'), TinkerMaterials.cobalt.getNuggetTag()).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_142284_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)TinkerMaterials.cobalt.getIngotTag())).m_142700_(consumer, this.modResource("common/cobalt_platform"));
        TinkerCommons.waxedCopperPlatform.forEach((age, block) -> {
            Block unwaxed = (Block)TinkerCommons.copperPlatform.get((Enum)age);
            ShapelessRecipeBuilder.m_126189_((ItemLike)block).m_126209_((ItemLike)unwaxed).m_126209_((ItemLike)Items.f_42784_).m_142409_("tconstruct:wax_copper_platform").m_142284_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)unwaxed)).m_142700_(consumer, this.modResource("common/copper_platform_waxing_" + age.toString().toLowerCase(Locale.ROOT)));
        });
        ShapelessRecipeBuilder.m_126189_(TinkerCommons.materialsAndYou).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerTables.pattern).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerTables.pattern)).m_142700_(consumer, this.prefix((Supplier)TinkerCommons.materialsAndYou, "common/"));
        ShapelessRecipeBuilder.m_126189_(TinkerCommons.tinkersGadgetry).m_126209_((ItemLike)Items.f_42517_).m_206419_(SlimeType.SKY.getSlimeballTag()).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_(SlimeType.SKY.getSlimeballTag())).m_142700_(consumer, this.prefix((Supplier)TinkerCommons.tinkersGadgetry, "common/"));
        ShapelessRecipeBuilder.m_126189_(TinkerCommons.punySmelting).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerSmeltery.grout).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerSmeltery.grout)).m_142700_(consumer, this.prefix((Supplier)TinkerCommons.punySmelting, "common/"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.mightySmelting).setFluidAndTime(TinkerFluids.searedStone, false, 250).setCast((ItemLike)Items.f_42517_, true).save(consumer, this.prefix((Supplier)TinkerCommons.mightySmelting, "common/"));
        ShapelessRecipeBuilder.m_126189_(TinkerCommons.fantasticFoundry).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerSmeltery.netherGrout).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerSmeltery.netherGrout)).m_142700_(consumer, this.prefix((Supplier)TinkerCommons.fantasticFoundry, "common/"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.encyclopedia).setFluidAndTime(TinkerFluids.moltenGold, true, 90).setCast((ItemLike)Items.f_42517_, true).save(consumer, this.prefix((Supplier)TinkerCommons.encyclopedia, "common/"));
        folder = "common/glass/";
        ShapedRecipeBuilder.m_126118_(TinkerCommons.clearGlassPane, (int)16).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlass).m_126130_("###").m_126130_("###").m_142284_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlass)).m_142700_(consumer, this.prefix((Supplier)TinkerCommons.clearGlassPane, folder));
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            Block block2 = (Block)TinkerCommons.clearStainedGlass.get((Enum)color);
            ShapedRecipeBuilder.m_126118_((ItemLike)block2, (int)8).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlass).m_206416_(Character.valueOf('X'), color.getDye().getTag()).m_126130_("###").m_126130_("#X#").m_126130_("###").m_142409_(this.modPrefix("stained_clear_glass")).m_142284_("has_clear_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlass)).m_142700_(consumer, this.prefix((IForgeRegistryEntry)block2, folder));
            Block pane = (Block)TinkerCommons.clearStainedGlassPane.get((Enum)color);
            ShapedRecipeBuilder.m_126118_((ItemLike)pane, (int)16).m_126127_(Character.valueOf('#'), (ItemLike)block2).m_126130_("###").m_126130_("###").m_142409_(this.modPrefix("stained_clear_glass_pane")).m_142284_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)block2)).m_142700_(consumer, this.prefix((IForgeRegistryEntry)pane, folder));
            ShapedRecipeBuilder.m_126118_((ItemLike)pane, (int)8).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlassPane).m_206416_(Character.valueOf('X'), color.getDye().getTag()).m_126130_("###").m_126130_("#X#").m_126130_("###").m_142409_(this.modPrefix("stained_clear_glass_pane")).m_142284_("has_clear_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlassPane)).m_142700_(consumer, this.wrap((IForgeRegistryEntry)pane, folder, "_from_panes"));
        }
        String glassVanillaFolder = folder + "vanilla/";
        Consumer vanillaGlassConsumer = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.GLASS_RECIPE_FIX});
        ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50273_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42686_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_126127_(Character.valueOf('O'), (ItemLike)Blocks.f_50080_).m_126130_("GGG").m_126130_("GSG").m_126130_("OOO").m_142284_("has_nether_star", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42686_)).m_142700_(vanillaGlassConsumer, this.prefix((IForgeRegistryEntry)Blocks.f_50273_, glassVanillaFolder));
        ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50329_).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('W'), ItemTags.f_13175_).m_126130_("GGG").m_126130_("QQQ").m_126130_("WWW").m_142284_("has_quartz", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42692_)).m_142700_(vanillaGlassConsumer, this.prefix((IForgeRegistryEntry)Blocks.f_50329_, glassVanillaFolder));
        ShapedRecipeBuilder.m_126116_((ItemLike)Items.f_42729_).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_42586_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_126130_("GGG").m_126130_("GEG").m_126130_("GTG").m_142284_("has_ender_eye", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_142700_(vanillaGlassConsumer, this.prefix((IForgeRegistryEntry)Items.f_42729_, glassVanillaFolder));
        ShapedRecipeBuilder.m_126118_((ItemLike)Items.f_42590_, (int)3).m_206416_(Character.valueOf('#'), Tags.Items.GLASS_COLORLESS).m_126130_("# #").m_126130_(" # ").m_142284_("has_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS_COLORLESS)).m_142700_(vanillaGlassConsumer, this.prefix((IForgeRegistryEntry)Items.f_42590_, glassVanillaFolder));
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42484_).m_126209_((ItemLike)Blocks.f_49994_).m_126209_((ItemLike)Blocks.f_49994_).m_126209_((ItemLike)Blocks.f_49994_).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Blocks.f_49994_)).m_142700_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)ConfigEnabledCondition.GRAVEL_TO_FLINT).build(consumer), this.modResource("common/flint"));
        ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50620_).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_152597_).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50094_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126130_("III").m_126130_("IXI").m_126130_("###").m_142284_("has_smooth_stone", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Blocks.f_152597_)).m_142700_(consumer, this.modResource("common/basalt_blast_furnace"));
    }

    private void addMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "common/materials/";
        this.metalCrafting(consumer, TinkerMaterials.cobalt, folder);
        this.metalCrafting(consumer, TinkerMaterials.slimesteel, folder);
        this.metalCrafting(consumer, TinkerMaterials.amethystBronze, folder);
        this.metalCrafting(consumer, TinkerMaterials.roseGold, folder);
        this.metalCrafting(consumer, TinkerMaterials.pigIron, folder);
        this.metalCrafting(consumer, TinkerMaterials.queensSlime, folder);
        this.metalCrafting(consumer, TinkerMaterials.manyullyn, folder);
        this.metalCrafting(consumer, TinkerMaterials.hepatizon, folder);
        this.packingRecipe(consumer, "ingot", (ItemLike)Items.f_151052_, "nugget", (ItemLike)TinkerMaterials.copperNugget, (TagKey)TinkerTags.Items.NUGGETS_COPPER, folder);
        this.packingRecipe(consumer, "ingot", (ItemLike)Items.f_42418_, "nugget", (ItemLike)TinkerMaterials.netheriteNugget, (TagKey)TinkerTags.Items.NUGGETS_NETHERITE, folder);
        Item cobaltIngot = TinkerMaterials.cobalt.getIngot();
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.rawCobalt, TinkerWorld.cobaltOre}), (ItemLike)cobaltIngot, (float)1.5f, (int)200).m_142284_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerWorld.rawCobalt)).m_142700_(consumer, this.wrap((IForgeRegistryEntry)cobaltIngot, folder, "_smelting"));
        this.packingRecipe(consumer, "raw_block", (ItemLike)TinkerWorld.rawCobaltBlock, "raw", (ItemLike)TinkerWorld.rawCobalt, (TagKey)TinkerTags.Items.RAW_COBALT, folder);
    }
}

