/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.inventory.SingleItemHandler;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.InventorySlotSyncPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.entity.component.DuctBlockEntity;

public class DuctItemHandler
extends SingleItemHandler<DuctBlockEntity> {
    public DuctItemHandler(DuctBlockEntity parent) {
        super((MantleBlockEntity)parent, 1);
    }

    public void setStack(ItemStack newStack) {
        Level world = ((DuctBlockEntity)this.parent).m_58904_();
        boolean hasChange = world != null && !ItemStack.m_41728_((ItemStack)this.getStack(), (ItemStack)newStack);
        super.setStack(newStack);
        if (hasChange) {
            if (!world.f_46443_) {
                BlockPos pos = ((DuctBlockEntity)this.parent).m_58899_();
                TinkerNetwork.getInstance().sendToClientsAround(new InventorySlotSyncPacket(newStack, 0, pos), (LevelAccessor)world, pos);
            } else {
                ((DuctBlockEntity)this.parent).updateFluid();
            }
        }
    }

    protected boolean isItemValid(ItemStack stack) {
        ItemStack container;
        if (!(stack.m_204117_(TinkerTags.Items.DUCT_CONTAINERS) || !(container = stack.getContainerItem()).m_41619_() && container.m_204117_(TinkerTags.Items.DUCT_CONTAINERS))) {
            return false;
        }
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).filter(cap -> !cap.getFluidInTank(0).isEmpty()).isPresent();
    }

    public FluidStack getFluid() {
        ItemStack stack = this.getStack();
        if (stack.m_41619_()) {
            return FluidStack.EMPTY;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }
}

