/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.smeltery.block.entity.inventory.DuctItemHandler;

public class DuctTankWrapper
implements IFluidHandler {
    private final IFluidHandler parent;
    private final DuctItemHandler itemHandler;

    public int getTanks() {
        return this.parent.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.parent.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.parent.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.itemHandler.getFluid().isFluidEqual(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        return this.parent.fill(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack fluid = this.itemHandler.getFluid();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.parent.drain(new FluidStack(fluid, maxDrain), action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return FluidStack.EMPTY;
        }
        return this.parent.drain(resource, action);
    }

    public DuctTankWrapper(IFluidHandler parent, DuctItemHandler itemHandler) {
        this.parent = parent;
        this.itemHandler = itemHandler;
    }
}

