/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits;

import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class DamageSpeedTradeModifier
extends Modifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "fake_attribute.mining_speed");
    private final float multiplier;
    private final Lazy<UUID> uuid = Lazy.of(() -> UUID.nameUUIDFromBytes(this.getId().toString().getBytes()));
    private final Lazy<String> attributeName = Lazy.of(() -> {
        ModifierId id = this.getId();
        return id.m_135815_() + "." + id.m_135827_() + ".attack_damage";
    });

    public DamageSpeedTradeModifier(float multiplier) {
        this.multiplier = multiplier;
    }

    private double getMultiplier(IToolStackView tool, int level) {
        return Math.sqrt((float)(tool.getDamage() * level) / tool.getMultiplier(ToolStats.DURABILITY)) * (double)this.multiplier;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        double boost = this.getMultiplier(tool, level);
        if (boost != 0.0 && tool.hasTag(TinkerTags.Items.HARVEST)) {
            tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(-boost)).m_130946_(" ").m_7220_(MINING_SPEED)));
        }
    }

    @Override
    public void addAttributes(IToolStackView tool, int level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (slot == EquipmentSlot.MAINHAND && (boost = this.getMultiplier(tool, level)) != 0.0) {
            consumer.accept(Attributes.f_22281_, new AttributeModifier((UUID)this.uuid.get(), (String)this.attributeName.get(), boost / 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 - this.getMultiplier(tool, level))));
        }
    }
}

