/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class InsatibleModifier
extends Modifier {
    private static float getBonus(LivingEntity attacker, int level) {
        int effectLevel = ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).getLevel(attacker) + 1;
        return (float)(level * effectLevel) / 4.0f;
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        return damage + InsatibleModifier.getBonus(context.getAttacker(), level) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).getLevel(attacker) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).apply(attacker, 100, effectLevel, true);
        }
        return 0;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = level * 2;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = InsatibleModifier.getBonus((LivingEntity)player, level);
        }
        this.addDamageTooltip(tool, bonus, tooltip);
    }
}

