/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.modifiers.spilling.ISpillingEffect;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class StrongBonesModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> STRONG_BONES = TConstruct.createKey("strong_bones");
    public static final TinkerDataCapability.TinkerDataKey<Integer> CALCIFIABLE = TConstruct.createKey("calcifable");
    public static final ResourceLocation SPILLING_EFFECT_ID = TConstruct.getResource("calcified");
    public static final ISpillingEffect SPILLING_EFFECT = new ISpillingEffect(){

        @Override
        public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
            LivingEntity target = context.getLivingTarget();
            if (target != null) {
                StrongBonesModifier.drinkMilk(target, (int)(400.0f * scale));
            }
        }

        public JsonObject serialize(JsonSerializationContext context) {
            return JsonUtils.withType(SPILLING_EFFECT_ID);
        }
    };
    public static final JsonDeserializer<ISpillingEffect> SPILLING_EFFECT_LOADER = (json, type, context) -> SPILLING_EFFECT;

    public StrongBonesModifier() {
        super(STRONG_BONES, true);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEntityUseItemEvent.Finish.class, StrongBonesModifier::onItemFinishUse);
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        IToolStackView replacement;
        super.onUnequip(tool, level, context);
        if (context.getChangedSlot() == EquipmentSlot.HEAD && ((replacement = context.getReplacementTool()) == null || replacement.getModifierLevel(this) == 0)) {
            context.getEntity().curePotionEffects(new ItemStack((ItemLike)tool.getItem()));
        }
    }

    private static void drinkMilk(LivingEntity living, int duration) {
        if (ModifierUtil.getTotalModifierLevel(living, STRONG_BONES) > 0) {
            MobEffectInstance effect = new MobEffectInstance(MobEffects.f_19606_, duration);
            effect.getCurativeItems().clear();
            effect.getCurativeItems().add(new ItemStack((ItemLike)living.m_6844_(EquipmentSlot.HEAD).m_41720_()));
            living.m_7292_(effect);
        }
        if (ModifierUtil.getTotalModifierLevel(living, CALCIFIABLE) > 0) {
            ((TinkerEffect)((Object)TinkerModifiers.calcifiedEffect.get())).apply(living, duration, 0, true);
        }
    }

    private static void onItemFinishUse(LivingEntityUseItemEvent.Finish event) {
        LivingEntity living = event.getEntityLiving();
        if (event.getItem().m_41720_() == Items.f_42455_) {
            StrongBonesModifier.drinkMilk(living, 1200);
        }
    }
}

