/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.level.block.SkullBlock;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.world.TinkerHeadType;

public class SkullModelHelper {
    public static final Map<TinkerHeadType, ModelLayerLocation> HEAD_LAYERS = Arrays.stream(TinkerHeadType.values()).collect(Collectors.toMap(Function.identity(), type -> new ModelLayerLocation(TConstruct.getResource(type.m_7912_() + "_head"), "main"), (a, b) -> a, () -> new EnumMap(TinkerHeadType.class)));

    private SkullModelHelper() {
    }

    private static ImmutableMap<SkullBlock.Type, SkullModelBase> inject(EntityModelSet modelSet, Map<SkullBlock.Type, SkullModelBase> original) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(original);
        HEAD_LAYERS.forEach((type, layer) -> builder.put((Object)type, (Object)new SkullModel(modelSet.m_171103_(layer))));
        return builder.build();
    }

    public static LayerDefinition createHeadLayer(int headX, int headY, int width, int height) {
        MeshDefinition mesh = new MeshDefinition();
        mesh.m_171576_().m_171599_("head", CubeListBuilder.m_171558_().m_171514_(headX, headY).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)width, (int)height);
    }

    public static LayerDefinition createHeadHatLayer(int hatX, int hatY, int width, int height) {
        MeshDefinition mesh = SkullModel.m_170946_();
        mesh.m_171576_().m_171597_("head").m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(hatX, hatY).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)width, (int)height);
    }

    public static LayerDefinition createPiglinHead() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition head = mesh.m_171576_().m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f).m_171514_(31, 1).m_171481_(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f).m_171514_(2, 4).m_171481_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f).m_171514_(2, 0).m_171481_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f), PartPose.f_171404_);
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(51, 6).m_171481_(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(39, 6).m_171481_(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }
}

