/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands;

import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.islands.variants.IIslandVariant;

public abstract class AbstractIslandStructure
extends StructureFeature<NoneFeatureConfiguration> {
    protected static final String[] SIZES = new String[]{"0x1x0", "2x2x4", "4x1x6", "8x1x11", "11x1x11"};

    public AbstractIslandStructure(IIslandSettings settings) {
        super(NoneFeatureConfiguration.f_67815_, context -> AbstractIslandStructure.pieceGeneratorSupplier((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, settings));
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static Optional<PieceGenerator<NoneFeatureConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, IIslandSettings settings) {
        ChunkPos chunkPos = context.f_197355_();
        Random random = new Random((long)chunkPos.f_45578_ + (long)chunkPos.f_45579_ * 10387313L);
        ChunkGenerator generator = context.f_197352_();
        Rotation rotation = Rotation.m_55956_((Random)random);
        int height = settings.getHeight(context.f_197355_(), generator, context.f_197357_(), rotation, random);
        BlockPos targetPos = context.f_197355_().m_151394_(height);
        if (!context.f_197358_().test(generator.m_203495_(QuartPos.m_175400_((int)targetPos.m_123341_()), QuartPos.m_175400_((int)targetPos.m_123342_()), QuartPos.m_175400_((int)targetPos.m_123343_())))) {
            return Optional.empty();
        }
        return Optional.of((builder, generatorContext) -> {
            WorldgenRandom rand = generatorContext.f_192708_();
            IIslandVariant variant = settings.getVariant((Random)rand);
            Mirror mirror = (Mirror)Util.m_137545_((Object[])Mirror.values(), (Random)rand);
            builder.m_142679_((StructurePiece)new SlimeIslandPiece(generatorContext.f_192704_(), variant, (String)Util.m_137545_((Object[])SIZES, (Random)rand), targetPos, variant.getTreeFeature((Random)rand), rotation, mirror));
        });
    }

    protected static interface IIslandSettings {
        public IIslandVariant getVariant(Random var1);

        default public int getHeight(ChunkPos chunkPos, ChunkGenerator generator, LevelHeightAccessor pLevel, Rotation rotation, Random random) {
            int xOffset;
            int yOffset = switch (rotation) {
                case Rotation.CLOCKWISE_90 -> {
                    xOffset = -5;
                    yield 5;
                }
                case Rotation.CLOCKWISE_180 -> {
                    xOffset = -5;
                    yield -5;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    xOffset = 5;
                    yield -5;
                }
                default -> {
                    xOffset = 5;
                    yield 5;
                }
            };
            int x = chunkPos.m_151382_(7);
            int z = chunkPos.m_151391_(7);
            int minXMinZ = generator.m_156179_(x, z, Heightmap.Types.WORLD_SURFACE_WG, pLevel);
            int minXMaxZ = generator.m_156179_(x, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, pLevel);
            int maxXMinZ = generator.m_156179_(x + xOffset, z, Heightmap.Types.WORLD_SURFACE_WG, pLevel);
            int maxXMaxZ = generator.m_156179_(x + xOffset, z + yOffset, Heightmap.Types.WORLD_SURFACE_WG, pLevel);
            return Math.min(Math.min(Math.min(minXMinZ, minXMaxZ), Math.min(maxXMinZ, maxXMaxZ)) + 60 + random.nextInt(50), generator.m_6331_() - 20);
        }
    }
}

