/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModItems;
import untamedwilds.init.ModTags;

public class TallPlantBlock
extends Block
implements BonemealableBlock,
IPostGenUpdate {
    protected static final VoxelShape SHAPE_TRUNK = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_STEM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_FLOWERING = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.f_61408_;
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.f_61387_;

    public TallPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_AGE, PROPERTY_STAGE});
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 1) {
            return SHAPE_FLOWERING;
        }
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        VoxelShape shape = (Integer)state.m_61143_((Property)PROPERTY_AGE) == 1 && (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 1 ? SHAPE_STEM : SHAPE_TRUNK;
        return shape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 1 ? Shapes.m_83040_() : this.m_5940_(state, worldIn, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i;
        if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0 && random.nextInt(8) == 0 && worldIn.m_46859_(pos.m_7494_()) && worldIn.m_7146_(pos.m_7494_()) >= 9 && (i = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos) + 1) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.grow((Level)worldIn, pos, random, i);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.ALOE_PLANTABLE_ON) || worldIn.m_8055_(pos.m_7495_()).m_60734_() == ModBlock.ZIMBABWE_ALOE.get();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return (Integer)worldIn.m_8055_(pos.m_6630_(i)).m_61143_((Property)PROPERTY_STAGE) != 1;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((BlockGetter)worldIn, pos);
        int j = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos);
        int k = i + j + 1;
        if ((Integer)worldIn.m_8055_(pos).m_61143_((Property)PROPERTY_AGE) == 0) {
            worldIn.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(5)));
        } else {
            BlockPos blockpos = pos.m_6630_(i);
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if ((Integer)blockstate.m_61143_((Property)PROPERTY_STAGE) == 1 || !worldIn.m_46859_(blockpos.m_7494_())) {
                return;
            }
            this.grow((Level)worldIn, blockpos, rand, k);
        }
    }

    protected void grow(Level worldIn, BlockPos posIn, Random rand, int p_220258_5_) {
        if (p_220258_5_ > 2 && rand.nextInt(3) == 0 || p_220258_5_ > 4) {
            worldIn.m_46597_(posIn.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(5))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)));
        } else {
            worldIn.m_46597_(posIn.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(5)));
            worldIn.m_46597_(posIn, (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(4)));
            int j = 1;
            for (int i = 3; i >= 0 && worldIn.m_8055_(posIn.m_6625_(j)).m_60734_() == ModBlock.ZIMBABWE_ALOE.get(); --i) {
                worldIn.m_46597_(posIn.m_6625_(j), (BlockState)((Block)ModBlock.ZIMBABWE_ALOE.get()).m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(Math.max(i, 1))));
                ++j;
            }
            worldIn.m_46597_(posIn.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(5)));
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return player.m_21205_().canPerformAction(ToolActions.SWORD_DIG) ? 1.0f : super.m_5880_(state, player, worldIn, pos);
    }

    protected int getNumReedBlocksAbove(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.m_8055_(pos.m_6630_(i + 1)).m_60734_() == ModBlock.ZIMBABWE_ALOE.get(); ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.m_8055_(pos.m_6625_(i + 1)).m_60734_() == ModBlock.ZIMBABWE_ALOE.get(); ++i) {
        }
        return i;
    }

    protected ItemLike getSeedsItem() {
        return (ItemLike)ModItems.SEED_ZIMBABWE_ALOE.get();
    }

    public ItemStack m_7397_(BlockGetter p_60261_, BlockPos p_60262_, BlockState p_60263_) {
        return new ItemStack(this.getSeedsItem());
    }

    @Override
    public void updatePostGen(LevelAccessor worldIn, BlockPos pos) {
        for (int i = 0; i < 3 && (worldIn.m_8055_(pos.m_6630_(i)).m_60795_() || worldIn.m_8055_(pos.m_6630_(i)).m_60734_() == ModBlock.ZIMBABWE_ALOE.get()); ++i) {
            worldIn.m_7731_(pos.m_6630_(i), (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(Math.max(1, i + 3))), 3);
        }
    }
}

