/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class CageBlockEntity
extends BlockEntity {
    private CompoundTag data;
    private boolean caged;

    public CageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlock.TILE_ENTITY_CAGE.get(), pos, state);
    }

    public static boolean isBlacklisted(Entity entity) {
        return entity.m_6095_().m_204039_(ModTags.EntityTags.CAGE_BLACKLIST);
    }

    public boolean cageEntity(Mob entity) {
        if (!(this.hasCagedEntity() || CageBlockEntity.isBlacklisted((Entity)entity) || !((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() && entity.m_5448_() != null)) {
            this.setTagCompound(EntityUtils.writeEntityToNBT((LivingEntity)entity));
            this.setCagedEntity(true);
            entity.m_146870_();
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean spawnCagedCreature(ServerLevel worldIn, BlockPos pos, boolean offsetHitbox) {
        EntityType<?> entity;
        if (!worldIn.f_46443_ && this.hasCagedEntity() && (entity = EntityUtils.getEntityTypeFromTag(this.getTagCompound(), null)) != null && worldIn.m_45772_(entity.m_20585_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - (offsetHitbox ? entity.m_20679_() + 0.4f : 0.0f)), (double)((float)pos.m_123343_() + 0.5f)))) {
            if (worldIn.m_8791_(this.data.m_128469_("EntityTag").m_128342_("UUID")) != null) {
                UntamedWilds.LOGGER.info("Randomizing UUID for mob");
                this.data.m_128469_("EntityTag").m_128362_("UUID", Mth.m_14062_((Random)worldIn.f_46441_));
            }
            Entity caged_entity = entity.m_20655_(worldIn, this.data, null, null, pos, MobSpawnType.DISPENSER, true, !Objects.equals(pos, this.m_58899_()));
            caged_entity.m_7678_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_() - (offsetHitbox ? (double)caged_entity.m_20206_() + 0.4 : 0.8), (double)((float)pos.m_123343_() + 0.5f), Mth.m_14177_((float)(worldIn.f_46441_.nextFloat() * 360.0f)), 0.0f);
            if (!worldIn.m_8860_(caged_entity)) {
                caged_entity.m_20084_(Mth.m_14062_((Random)worldIn.f_46441_));
                worldIn.m_47205_(caged_entity);
            }
            this.setTagCompound(null);
            this.caged = true;
            return true;
        }
        return false;
    }

    @Nullable
    public CompoundTag getTagCompound() {
        return this.data;
    }

    private void setTagCompound(@Nullable CompoundTag nbt) {
        this.data = nbt;
    }

    public boolean hasTagCompound() {
        return this.data != null;
    }

    public boolean hasCagedEntity() {
        return this.caged;
    }

    private void setCagedEntity(boolean trap) {
        this.caged = trap;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setTagCompound(compound.m_6426_());
        this.setCagedEntity(compound.m_128471_("closed"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("closed", this.hasCagedEntity());
        if (this.getTagCompound() != null) {
            compound.m_128365_("EntityTag", (Tag)this.getTagCompound().m_128469_("EntityTag"));
        }
    }
}

