/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import untamedwilds.entity.mammal.EntityHippo;

public class ModelHippo
extends AdvancedEntityModel<EntityHippo> {
    public AdvancedModelBox body_main;
    public AdvancedModelBox head_neck;
    public AdvancedModelBox arm_right;
    public AdvancedModelBox arm_left;
    public AdvancedModelBox leg_right;
    public AdvancedModelBox leg_left;
    public AdvancedModelBox head_face;
    public AdvancedModelBox head_jaw;
    public AdvancedModelBox face_ear_right;
    public AdvancedModelBox head_jaw_1;
    public AdvancedModelBox face_ear_left;
    public AdvancedModelBox head_jaw_2;
    public AdvancedModelBox tooth_r;
    public AdvancedModelBox tooth_l;
    public AdvancedModelBox eye_right;
    public AdvancedModelBox eye_left;
    public AdvancedModelBox arm_right_2;
    public AdvancedModelBox arm_left_2;
    public AdvancedModelBox leg_right_2;
    public AdvancedModelBox leg_left_2;
    private final ModelAnimator animator;

    public ModelHippo() {
        this.texWidth = 128;
        this.texHeight = 64;
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_main.setRotationPoint(0.0f, 12.5f, 0.0f);
        this.body_main.addBox(-6.0f, -6.0f, -12.0f, 12.0f, 12.0f, 24.0f, 0.0f);
        this.head_neck = new AdvancedModelBox((AdvancedEntityModel)this, 48, 0);
        this.head_neck.setRotationPoint(0.0f, -0.6f, -10.0f);
        this.head_neck.addBox(-5.0f, -5.0f, -6.0f, 10.0f, 10.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.head_neck, 0.045553092f, 0.0f, 0.0f);
        this.head_face = new AdvancedModelBox((AdvancedEntityModel)this, 0, 36);
        this.head_face.setRotationPoint(0.0f, -2.0f, -5.0f);
        this.head_face.addBox(-4.5f, -3.5f, -6.0f, 9.0f, 9.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.head_face, 0.2f, 0.0f, 0.0f);
        this.eye_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 37);
        this.eye_left.setRotationPoint(4.51f, -2.0f, -4.0f);
        this.eye_left.addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f);
        this.eye_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 37);
        this.eye_right.setRotationPoint(-4.51f, -2.0f, -4.0f);
        this.eye_right.addBox(0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f);
        this.face_ear_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 36);
        this.face_ear_left.mirror = true;
        this.face_ear_left.setRotationPoint(3.0f, -3.0f, -3.0f);
        this.face_ear_left.addBox(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.face_ear_left, 0.13665928f, 0.091106184f, 0.3642502f);
        this.face_ear_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 36);
        this.face_ear_right.setRotationPoint(-3.0f, -3.0f, -3.0f);
        this.face_ear_right.addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.face_ear_right, 0.13665928f, -0.091106184f, -0.3642502f);
        this.head_jaw = new AdvancedModelBox((AdvancedEntityModel)this, 36, 36);
        this.head_jaw.setRotationPoint(0.0f, 0.0f, -6.0f);
        this.head_jaw.addBox(-4.0f, -3.0f, -7.0f, 8.0f, 5.0f, 8.0f, 0.0f);
        this.head_jaw_2 = new AdvancedModelBox((AdvancedEntityModel)this, 36, 49);
        this.head_jaw_2.setRotationPoint(0.0f, 2.0f, 0.0f);
        this.head_jaw_2.addBox(-4.0f, 0.0f, -7.0f, 8.0f, 1.0f, 8.0f, 0.0f);
        this.head_jaw_1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 53);
        this.head_jaw_1.setRotationPoint(0.0f, 1.5f, -4.5f);
        this.head_jaw_1.addBox(-4.0f, 0.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.0f);
        this.tooth_r = new AdvancedModelBox((AdvancedEntityModel)this, 0, 53);
        this.tooth_r.setRotationPoint(-2.5f, 0.0f, -5.5f);
        this.tooth_r.addBox(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f);
        this.tooth_l = new AdvancedModelBox((AdvancedEntityModel)this, 0, 53);
        this.tooth_l.setRotationPoint(2.5f, 0.0f, -5.5f);
        this.tooth_l.addBox(-0.5f, -2.0f, -1.0f, 1.0f, 2.0f, 2.0f, 0.0f);
        this.arm_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.arm_right.setRotationPoint(-3.49f, 3.5f, -8.5f);
        this.arm_right.addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.arm_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 12);
        this.arm_right_2.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.arm_right_2.addBox(-2.51f, 0.0f, -2.51f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.arm_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.arm_left.mirror = true;
        this.arm_left.setRotationPoint(3.49f, 3.5f, -8.5f);
        this.arm_left.addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.arm_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 12);
        this.arm_left_2.mirror = true;
        this.arm_left_2.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.arm_left_2.addBox(-2.51f, 0.0f, -2.51f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.leg_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.leg_right.setRotationPoint(-3.49f, 3.5f, 8.5f);
        this.leg_right.addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.leg_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 12);
        this.leg_right_2.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.leg_right_2.addBox(-2.51f, 0.0f, -2.51f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.leg_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.leg_left.setRotationPoint(3.49f, 3.5f, 8.5f);
        this.leg_left.addBox(-2.5f, 0.0f, -2.5f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.leg_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 12);
        this.leg_left_2.setRotationPoint(0.0f, 3.0f, 0.0f);
        this.leg_left_2.addBox(-2.51f, 0.0f, -2.51f, 5.0f, 5.0f, 5.0f, 0.0f);
        this.body_main.addChild((BasicModelPart)this.arm_left);
        this.head_jaw_1.addChild((BasicModelPart)this.tooth_r);
        this.head_face.addChild((BasicModelPart)this.face_ear_left);
        this.leg_left.addChild((BasicModelPart)this.leg_left_2);
        this.arm_left.addChild((BasicModelPart)this.arm_left_2);
        this.head_neck.addChild((BasicModelPart)this.head_face);
        this.head_jaw.addChild((BasicModelPart)this.head_jaw_2);
        this.head_face.addChild((BasicModelPart)this.head_jaw);
        this.head_face.addChild((BasicModelPart)this.head_jaw_1);
        this.body_main.addChild((BasicModelPart)this.head_neck);
        this.body_main.addChild((BasicModelPart)this.leg_right);
        this.body_main.addChild((BasicModelPart)this.leg_left);
        this.head_jaw_1.addChild((BasicModelPart)this.tooth_l);
        this.arm_right.addChild((BasicModelPart)this.arm_right_2);
        this.body_main.addChild((BasicModelPart)this.arm_right);
        this.head_face.addChild((BasicModelPart)this.face_ear_right);
        this.leg_right.addChild((BasicModelPart)this.leg_right_2);
        this.head_face.addChild((BasicModelPart)this.eye_left);
        this.head_face.addChild((BasicModelPart)this.eye_right);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.head_neck, (Object)this.arm_right, (Object)this.arm_left, (Object)this.leg_right, (Object)this.leg_left, (Object)this.head_face, (Object)this.head_jaw, (Object)this.face_ear_right, (Object)this.head_jaw_1, (Object)this.face_ear_left, (Object)this.head_jaw_2, (Object[])new AdvancedModelBox[]{this.tooth_r, this.tooth_l, this.eye_right, this.eye_left, this.arm_right_2, this.arm_left_2, this.leg_right_2, this.leg_left_2});
    }

    private void animate(IAnimatedEntity entityIn) {
        this.resetToDefaultPose();
        EntityHippo bear = (EntityHippo)entityIn;
        this.animator.update((IAnimatedEntity)bear);
        this.animator.setAnimation(EntityHippo.EAT);
        this.animator.startKeyframe(12);
        this.rotate(this.animator, this.head_neck, 18.26f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, 26.09f, 0.0f, 5.22f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(12);
        this.rotate(this.animator, this.head_neck, 18.26f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, 20.87f, 5.22f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -10.43f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 10.43f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(12);
        this.rotate(this.animator, this.head_neck, 18.26f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, 26.09f, -5.22f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(12);
        this.animator.setAnimation(EntityHippo.IDLE_YAWN);
        this.animator.startKeyframe(8);
        this.rotate(this.animator, this.head_neck, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -10.43f, 0.0f, 0.0f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 54.78f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.rotate(this.animator, this.head_neck, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -10.43f, 0.0f, 2.61f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -44.35f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 62.61f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.rotate(this.animator, this.head_neck, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -10.43f, 0.0f, -2.61f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -44.35f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 62.61f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(8);
        this.animator.setAnimation(EntityHippo.IDLE_LOOK);
        this.animator.startKeyframe(32);
        this.rotate(this.animator, this.head_neck, -20.87f, 5.22f, 0.0f);
        this.rotate(this.animator, this.head_face, 15.65f, 31.3f, 7.83f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(64);
        this.rotate(this.animator, this.head_neck, -20.87f, -7.83f, 0.0f);
        this.rotate(this.animator, this.head_face, 13.04f, -7.83f, -5.22f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(32);
        this.animator.setAnimation(EntityHippo.ATTACK);
        this.animator.startKeyframe(6);
        this.rotate(this.animator, this.head_neck, -13.05f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, 13.05f, -10.43f, -7.83f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 36.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.rotate(this.animator, this.head_neck, -13.05f, 7.83f, 0.0f);
        this.rotate(this.animator, this.head_face, -13.04f, 23.48f, -26.09f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 36.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.rotate(this.animator, this.head_neck, -13.05f, -10.43f, 0.0f);
        this.rotate(this.animator, this.head_face, -13.04f, -20.87f, -2.61f);
        this.animator.move(this.head_jaw, 0.0f, -1.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw, -28.7f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_jaw_1, 36.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(6);
        this.animator.setAnimation(EntityHippo.IDLE_TALK);
        this.animator.startKeyframe(10);
        this.rotate(this.animator, this.head_jaw, 26.09f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -26.09f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(EntityHippo hippo, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animate(hippo);
        float globalSpeed = 1.5f;
        float globalDegree = 1.0f;
        float f = limbSwing / 2.0f;
        if (limbSwingAmount > 0.4f) {
            limbSwingAmount = 0.4f;
        }
        if (!hippo.shouldRenderEyes()) {
            this.eye_right.setRotationPoint(-2.0f, -2.0f, -4.0f);
            this.eye_left.setRotationPoint(2.0f, -2.0f, -4.0f);
        }
        if (hippo.m_20069_() && !hippo.m_20096_()) {
            float pitch = Mth.m_14036_((float)(hippo.m_146909_() - 10.0f), (float)-25.0f, (float)25.0f);
            this.setRotateAngle(this.body_main, (float)((double)pitch * Math.PI / 180.0), 0.0f, 0.0f);
        }
        if (!hippo.m_5803_()) {
            this.faceTarget(netHeadYaw, headPitch, 3.0f, new AdvancedModelBox[]{this.head_neck});
            this.faceTarget(netHeadYaw, headPitch, 3.0f, new AdvancedModelBox[]{this.head_face});
        }
        this.head_jaw_1.setScaleX(0.9f);
        this.body_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.bob(this.body_main, 0.4f * globalSpeed, 0.1f, false, ageInTicks / 20.0f, 2.0f);
        this.bob(this.arm_right, 0.4f * globalSpeed, 0.1f, false, -ageInTicks / 20.0f, 2.0f);
        this.bob(this.arm_left, 0.4f * globalSpeed, 0.1f, false, -ageInTicks / 20.0f, 2.0f);
        this.bob(this.leg_right, 0.4f * globalSpeed, 0.1f, false, -ageInTicks / 20.0f, 2.0f);
        this.bob(this.leg_left, 0.4f * globalSpeed, 0.1f, false, -ageInTicks / 20.0f, 2.0f);
        this.walk(this.head_face, 0.4f * globalSpeed, 0.03f, false, 2.8f, 0.06f, ageInTicks / 20.0f, 2.0f);
        if (hippo.angryProgress != 0) {
            this.progressRotation(this.head_jaw_1, hippo.angryProgress, 0.3642502f, 0.0f, 0.0f, 40.0f);
        }
        if (hippo.sitProgress != 0) {
            if (hippo.isSitting()) {
                this.progressPosition(this.body_main, hippo.sitProgress, 0.0f, 18.5f, 0.0f, 40.0f);
                this.progressRotation(this.body_main, hippo.sitProgress, 0.0f, 0.091106184f, 0.0f, 40.0f);
                this.progressPosition(this.head_neck, hippo.sitProgress, 0.0f, 0.0f, -10.0f, 40.0f);
                this.progressRotation(this.head_neck, hippo.sitProgress, 0.18203785f, 0.0f, 0.0f, 40.0f);
                this.progressPosition(this.head_face, hippo.sitProgress, 0.0f, -1.0f, -5.0f, 40.0f);
                this.progressRotation(this.head_face, hippo.sitProgress, 0.0f, -0.27314404f, 0.045553092f, 40.0f);
                this.progressRotation(this.arm_right, hippo.sitProgress, -1.5025539f, 0.27314404f, 0.0f, 40.0f);
                this.progressRotation(this.arm_left, hippo.sitProgress, -1.5025539f, -0.27314404f, 0.0f, 40.0f);
                this.progressRotation(this.leg_right, hippo.sitProgress, -1.548107f, 2.5497515f, 0.0f, 40.0f);
                this.progressRotation(this.leg_left, hippo.sitProgress, -1.548107f, -2.5497515f, 0.0f, 40.0f);
            }
            if (hippo.m_5803_()) {
                this.progressPosition(this.body_main, hippo.sitProgress, 0.0f, 18.5f, 0.0f, 40.0f);
                this.progressRotation(this.body_main, hippo.sitProgress, 0.0f, 0.091106184f, 0.0f, 40.0f);
                this.progressPosition(this.head_neck, hippo.sitProgress, 0.0f, 0.0f, -10.0f, 40.0f);
                this.progressRotation(this.head_neck, hippo.sitProgress, 0.18203785f, 0.0f, 0.0f, 40.0f);
                this.progressPosition(this.head_face, hippo.sitProgress, 0.0f, -1.0f, -5.0f, 40.0f);
                this.progressRotation(this.head_face, hippo.sitProgress, 0.0f, -0.27314404f, 0.045553092f, 40.0f);
                this.progressRotation(this.arm_right, hippo.sitProgress, -1.5025539f, 0.27314404f, 0.0f, 40.0f);
                this.progressRotation(this.arm_left, hippo.sitProgress, -1.5025539f, -0.27314404f, 0.0f, 40.0f);
                this.progressRotation(this.leg_right, hippo.sitProgress, -1.548107f, 2.5497515f, 0.0f, 40.0f);
                this.progressRotation(this.leg_left, hippo.sitProgress, -1.548107f, -2.5497515f, 0.0f, 40.0f);
            }
        }
        if (hippo.canMove()) {
            this.bob(this.body_main, 0.6f * globalSpeed, 0.6f * globalDegree, true, f, limbSwingAmount);
            this.walk(this.head_neck, 0.6f * globalSpeed, 0.2f * globalDegree, false, 0.0f, 0.0f, f, limbSwingAmount);
            this.walk(this.head_face, 0.6f * globalSpeed, 0.15f * globalDegree, true, 0.0f, 0.0f, f, limbSwingAmount);
            this.walk(this.arm_right, -0.6f * globalSpeed, 1.4f * globalDegree, true, 0.0f, 1.4f, f, limbSwingAmount);
            this.walk(this.arm_right_2, -0.6f * globalSpeed, 1.4f * globalDegree, false, -1.0f, 1.4f, f, limbSwingAmount * 1.2f);
            this.walk(this.arm_left, -0.6f * globalSpeed, 1.4f * globalDegree, true, 2.0f, 1.4f, f, limbSwingAmount);
            this.walk(this.arm_left_2, -0.6f * globalSpeed, 1.4f * globalDegree, false, 1.0f, 1.4f, f, limbSwingAmount * 1.2f);
            this.walk(this.leg_right, 0.6f * globalSpeed, 1.4f * globalDegree, false, 2.8f, 0.0f, f, limbSwingAmount);
            this.walk(this.leg_right_2, 0.6f * globalSpeed, 1.4f * globalDegree, true, 1.8f, 0.0f, f, limbSwingAmount);
            this.walk(this.leg_left, 0.6f * globalSpeed, 1.4f * globalDegree, false, 0.8f, 0.0f, f, limbSwingAmount);
            this.walk(this.leg_left_2, 0.6f * globalSpeed, 1.4f * globalDegree, true, -0.2f, 0.0f, f, limbSwingAmount);
        }
    }
}

