/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import untamedwilds.entity.reptile.EntityTortoise;

public class ModelTortoise
extends AdvancedEntityModel<EntityTortoise> {
    public AdvancedModelBox body_main;
    public AdvancedModelBox neck;
    public AdvancedModelBox hand_right;
    public AdvancedModelBox leg_right;
    public AdvancedModelBox main_body;
    public AdvancedModelBox hand_left;
    public AdvancedModelBox leg_left;
    public AdvancedModelBox body_tail;
    public AdvancedModelBox head;
    public AdvancedModelBox shape8;
    private final ModelAnimator animator;

    public ModelTortoise() {
        this.texWidth = 64;
        this.texHeight = 32;
        this.leg_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 10);
        this.leg_right.setRotationPoint(-2.4f, -0.4f, 3.9f);
        this.leg_right.addBox(-1.5f, 0.0f, 0.0f, 3.0f, 4.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_right, 0.18203785f, -1.0471976f, -0.13665928f);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.neck.setRotationPoint(0.0f, -0.4f, -3.4f);
        this.neck.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.neck, -0.3642502f, 0.0f, 0.0f);
        this.main_body = new AdvancedModelBox((AdvancedEntityModel)this, 20, 0);
        this.main_body.setRotationPoint(0.0f, 1.0f, 0.0f);
        this.main_body.addBox(-4.0f, -4.0f, -5.0f, 8.0f, 4.0f, 10.0f, 0.0f);
        this.setRotateAngle(this.main_body, -0.091106184f, 0.0f, 0.0f);
        this.shape8 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.shape8.setRotationPoint(0.0f, -6.0f, 0.0f);
        this.shape8.addBox(-3.0f, 0.0f, -4.0f, 6.0f, 2.0f, 8.0f, 0.0f);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this, 0, 24);
        this.head.setRotationPoint(0.0f, 0.3f, -3.4f);
        this.head.addBox(-1.5f, -1.5f, -4.0f, 3.0f, 3.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.head, 0.3642502f, 0.0f, 0.0f);
        this.head.scaleX = 1.01f;
        this.body_tail = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_tail.setRotationPoint(0.0f, 0.0f, 4.8f);
        this.body_tail.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.body_tail, 0.31869712f, 0.0f, 0.0f);
        this.leg_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 10);
        this.leg_left.setRotationPoint(2.4f, -0.4f, 3.9f);
        this.leg_left.addBox(-1.5f, 0.0f, 0.0f, 3.0f, 4.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_left, 0.18203785f, 1.0471976f, 0.13665928f);
        this.hand_right = new AdvancedModelBox((AdvancedEntityModel)this, 10, 10);
        this.hand_right.setRotationPoint(-3.1f, -0.1f, -4.3f);
        this.hand_right.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.hand_right, -0.13665928f, -1.2292354f, 0.18203785f);
        this.hand_left = new AdvancedModelBox((AdvancedEntityModel)this, 10, 10);
        this.hand_left.mirror = true;
        this.hand_left.setRotationPoint(3.1f, -0.1f, -4.3f);
        this.hand_left.addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.hand_left, -0.13665928f, 1.2292354f, -0.18203785f);
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 26, 15);
        this.body_main.setRotationPoint(0.0f, 20.0f, 0.0f);
        this.body_main.addBox(-3.0f, -0.6f, -4.0f, 6.0f, 2.0f, 8.0f, 0.0f);
        this.setRotateAngle(this.body_main, -0.045553092f, 0.0f, 0.0f);
        this.body_main.addChild((BasicModelPart)this.leg_right);
        this.body_main.addChild((BasicModelPart)this.neck);
        this.body_main.addChild((BasicModelPart)this.main_body);
        this.main_body.addChild((BasicModelPart)this.shape8);
        this.neck.addChild((BasicModelPart)this.head);
        this.body_main.addChild((BasicModelPart)this.body_tail);
        this.body_main.addChild((BasicModelPart)this.leg_left);
        this.body_main.addChild((BasicModelPart)this.hand_right);
        this.body_main.addChild((BasicModelPart)this.hand_left);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.neck, (Object)this.hand_right, (Object)this.leg_right, (Object)this.main_body, (Object)this.hand_left, (Object)this.leg_left, (Object)this.body_tail, (Object)this.head, (Object)this.shape8);
    }

    public void setupAnim(EntityTortoise tortoise, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(tortoise);
        limbSwing = (float)((double)limbSwing * -1.2);
        float globalSpeed = 1.4f;
        float globalDegree = 2.0f;
        if (!tortoise.isSitting()) {
            this.faceTarget(netHeadYaw, headPitch, 3.0f, new AdvancedModelBox[]{this.neck});
            this.faceTarget(netHeadYaw, headPitch, 3.0f, new AdvancedModelBox[]{this.head});
        }
        this.flap(this.hand_left, globalSpeed, globalDegree * 0.6f, false, 0.5f, -0.8f, limbSwing, limbSwingAmount);
        this.walk(this.hand_left, globalSpeed, globalDegree * 0.3f, false, 0.0f, 0.8f, limbSwing, limbSwingAmount);
        this.flap(this.hand_right, globalSpeed, -globalDegree * 0.6f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.hand_right, globalSpeed, globalDegree * 0.3f, true, 0.5f, -0.8f, limbSwing, limbSwingAmount);
        this.swing(this.leg_left, globalSpeed, globalDegree * 0.6f, false, 2.8f, 0.1f, limbSwing, limbSwingAmount);
        this.flap(this.leg_left, globalSpeed, globalDegree * 0.2f, false, 1.2f, -0.8f, limbSwing, limbSwingAmount);
        this.swing(this.leg_right, globalSpeed, globalDegree * 0.6f, true, 4.4f, 0.1f, limbSwing, limbSwingAmount);
        this.flap(this.leg_right, globalSpeed, globalDegree * 0.2f, true, 2.8f, -0.8f, limbSwing, limbSwingAmount);
        this.flap(this.body_main, globalSpeed / 2.0f, globalDegree * 0.1f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
        this.swing(this.body_main, globalSpeed / 2.0f, globalDegree * 0.1f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
        if (tortoise.sitProgress != 0) {
            this.progressPosition(this.body_main, tortoise.sitProgress, 0.0f, 22.6f, 0.0f, 20.0f);
            this.progressPosition(this.neck, tortoise.sitProgress, 0.0f, -1.1f, 0.5f, 20.0f);
            this.progressRotation(this.neck, tortoise.sitProgress, (float)Math.toRadians(-2.61f), 0.0f, 0.0f, 20.0f);
            this.progressPosition(this.head, tortoise.sitProgress, 0.0f, 0.8f, -1.7f, 20.0f);
            this.progressRotation(this.head, tortoise.sitProgress, 0.0f, 0.0f, 0.0f, 20.0f);
            this.progressPosition(this.hand_right, tortoise.sitProgress, -1.1f, -0.1f, -5.7f, 20.0f);
            this.progressRotation(this.hand_right, tortoise.sitProgress, (float)Math.toRadians(80.87f), (float)Math.toRadians(-60.0), (float)Math.toRadians(10.43f), 20.0f);
            this.progressPosition(this.hand_left, tortoise.sitProgress, 1.1f, -0.1f, -5.7f, 20.0f);
            this.progressRotation(this.hand_left, tortoise.sitProgress, (float)Math.toRadians(80.87f), (float)Math.toRadians(60.0), (float)Math.toRadians(-10.43f), 20.0f);
            this.progressPosition(this.leg_right, tortoise.sitProgress, -4.4f, -0.4f, 3.9f, 20.0f);
            this.progressRotation(this.leg_right, tortoise.sitProgress, (float)Math.toRadians(10.43f), (float)Math.toRadians(-5.22f), (float)Math.toRadians(-80.87f), 20.0f);
            this.progressPosition(this.leg_left, tortoise.sitProgress, 4.4f, -0.4f, 3.9f, 20.0f);
            this.progressRotation(this.leg_left, tortoise.sitProgress, (float)Math.toRadians(10.43f), (float)Math.toRadians(5.22f), (float)Math.toRadians(80.87f), 20.0f);
        }
    }
}

