/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.compat.CompatBridge;
import untamedwilds.compat.CompatSereneSeasons;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.HerdEntity;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.EntityDataHolderClient;
import untamedwilds.util.EntityDataListenerEvent;
import untamedwilds.util.EntityUtils;
import untamedwilds.util.SpeciesDataHolder;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ComplexMob
extends TamableAnimal {
    public static HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> TEXTURES_COMMON = new HashMap();
    public static HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> TEXTURES_RARE = new HashMap();
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_ANGRY = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(ComplexMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(ComplexMobTerrestrial.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(ComplexMobTerrestrial.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public HerdEntity herd = null;
    public float turn_speed = 1.0f;
    public int huntingCooldown;
    public static HashMap<EntityType<?>, EntityDataHolder> ENTITY_DATA_HASH = new HashMap();
    public static HashMap<EntityType<?>, EntityDataHolderClient> CLIENT_DATA_HASH = new HashMap();

    public ComplexMob(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SKIN, (Object)0);
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(IS_ANGRY, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.huntingCooldown > 0) {
            --this.huntingCooldown;
        }
    }

    public static EntityDataHolder getEntityData(EntityType<?> typeIn) {
        if (!ENTITY_DATA_HASH.containsKey(typeIn)) {
            EntityDataListenerEvent.registerEntityData(typeIn);
        }
        return ENTITY_DATA_HASH.get(typeIn);
    }

    protected SoundEvent m_7515_() {
        return EntityUtils.getSound(this.m_6095_(), this.getVariant(), "ambient");
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return EntityUtils.getSound(this.m_6095_(), this.getVariant(), "hurt", SoundEvents.f_11915_);
    }

    protected SoundEvent m_5592_() {
        return EntityUtils.getSound(this.m_6095_(), this.getVariant(), "death", SoundEvents.f_11910_);
    }

    protected SoundEvent getThreatSound() {
        return EntityUtils.getSound(this.m_6095_(), this.getVariant(), "threat");
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public boolean m_6573_(Player player) {
        if (player.m_7500_()) {
            return !this.m_21523_();
        }
        return !this.m_21523_() && this.m_21824_();
    }

    public boolean m_8023_() {
        return true;
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean isNotMoving() {
        return this.m_20184_().f_82479_ == 0.0 && this.m_20184_().f_82481_ == 0.0;
    }

    public boolean canBeTargeted() {
        return true;
    }

    public double getCurrentSpeed() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
    }

    public int m_8100_() {
        return 300;
    }

    protected int m_6552_(Player p_27590_) {
        int xp = Math.max(ComplexMob.getEcoLevel((LivingEntity)this) / 2, 1);
        return xp + this.f_19853_.f_46441_.nextInt(xp);
    }

    public static void processData(EntityDataHolder dataIn, EntityType<?> typeIn) {
        ENTITY_DATA_HASH.put(typeIn, dataIn);
        ComplexMob.processSkins(dataIn, typeIn.getRegistryName().m_135815_());
        for (SpeciesDataHolder speciesData : ENTITY_DATA_HASH.get(typeIn).getSpeciesData()) {
            if (!CLIENT_DATA_HASH.containsKey(typeIn)) {
                CLIENT_DATA_HASH.put(typeIn, new EntityDataHolderClient(new HashMap<Integer, Map<String, SoundEvent>>(), new HashMap<Integer, String>()));
            }
            ComplexMob.CLIENT_DATA_HASH.get(typeIn).species_data.put(speciesData.getVariant(), speciesData.getName());
        }
    }

    public static void processSkins(EntityDataHolder dataIn, String nameIn) {
        for (SpeciesDataHolder speciesDatum : dataIn.getSpeciesData()) {
            EntityUtils.buildSkinArrays(nameIn, speciesDatum.getName().toLowerCase(), dataIn, speciesDatum.getVariant(), TEXTURES_COMMON, TEXTURES_RARE);
        }
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(SKIN);
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public <T extends ComplexMob> void chooseSkinForSpecies(T entityIn, boolean allowRares) {
        String name;
        if (entityIn.m_6095_().getRegistryName() != null && this instanceof INewSkins && !this.f_19853_.f_46443_ && !TEXTURES_COMMON.get(name = entityIn.m_6095_().getRegistryName().m_135815_()).isEmpty()) {
            boolean isRare = allowRares && TEXTURES_RARE.get(name).containsKey(this.getVariant()) && (double)this.f_19796_.nextFloat() < (Double)ConfigGamerules.rareSkinChance.get();
            int skin = this.f_19796_.nextInt(isRare ? TEXTURES_RARE.get(name).get(this.getVariant()).size() : TEXTURES_COMMON.get(name).get(this.getVariant()).size()) + (isRare ? 100 : 0);
            this.setSkin(skin);
        }
    }

    public float getModelScale() {
        return ComplexMob.getEntityData(this.m_6095_()).getScale(this.getVariant());
    }

    public float getMobSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setMobSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    public void setRandomMobSize() {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(this.getModelScale() + (float)this.f_19796_.nextGaussian() * 0.1f));
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public boolean isMale() {
        return this.getGender() == 0;
    }

    public String getGenderString() {
        return this.isMale() ? "male" : "female";
    }

    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue()) {
            if (CompatBridge.SereneSeasons) {
                return CompatSereneSeasons.isCurrentSeason(this.f_19853_, this.getBreedingSeason());
            }
            return true;
        }
        return false;
    }

    public <T extends ComplexMob> void breed() {
        int bound = 1 + (this.getOffspring() > 0 ? this.f_19796_.nextInt(this.getOffspring() + 1) : 0);
        for (int i = 0; i < bound; ++i) {
            ComplexMob child = (ComplexMob)this.m_142606_((ServerLevel)this.f_19853_, (AgeableMob)this);
            if (child == null) continue;
            child.setVariant(this.getVariant());
            child.m_146762_(this.getAdulthoodTime() * -1);
            child.setGender(this.f_19796_.nextInt(2));
            child.setRandomMobSize();
            child.m_6863_(true);
            child.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            if (this.m_142480_() != null) {
                child.m_21828_((Player)this.m_142480_());
            }
            if (this instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)((Object)child)).updateAttributes();
            }
            if (TEXTURES_COMMON.containsKey(child.m_6095_().getRegistryName().m_135815_())) {
                this.chooseSkinForSpecies(child, true);
            }
            this.f_19853_.m_7967_((Entity)child);
            this.f_19853_.m_7605_((Entity)this, (byte)18);
        }
    }

    protected <T extends ComplexMob> T create_offspring(T entity) {
        entity.setGender(this.f_19796_.nextInt(2));
        entity.setRandomMobSize();
        entity.setVariant(this.getVariant());
        if (entity instanceof INeedsPostUpdate) {
            ((INeedsPostUpdate)((Object)entity)).updateAttributes();
        }
        return entity;
    }

    public String getBreedingSeason() {
        return ComplexMob.getEntityData(this.m_6095_()).getBreedingSeason(this.getVariant());
    }

    public int getAdulthoodTime() {
        return ComplexMob.getEntityData(this.m_6095_()).getGrowingTime(this.getVariant()) * (Integer)ConfigGamerules.cycleLength.get() * 2;
    }

    public int getPregnancyTime() {
        return ComplexMob.getEntityData(this.m_6095_()).getGrowingTime(this.getVariant()) * (Integer)ConfigGamerules.cycleLength.get();
    }

    protected int getOffspring() {
        return ComplexMob.getEntityData(this.m_6095_()).getOffspring(this.getVariant());
    }

    public boolean m_6898_(ItemStack stack) {
        if (ComplexMob.getEntityData(this.m_6095_()).getFavouriteFood(this.getVariant()).m_41720_().equals(Blocks.f_50016_.m_5456_())) {
            return false;
        }
        return stack.m_41720_().equals(ComplexMob.getEntityData(this.m_6095_()).getFavouriteFood(this.getVariant()).m_41720_());
    }

    public boolean m_7066_(ItemStack stack) {
        return false;
    }

    private boolean isBlinking() {
        return this.f_19797_ % 60 > 53;
    }

    public boolean shouldRenderEyes() {
        return !this.m_5803_() && !this.f_20890_ && !this.isBlinking() && this.f_20916_ == 0;
    }

    public boolean canMove() {
        return !this.isSitting() && !this.m_5803_() && !this.m_20160_();
    }

    public void setHome(BlockPos position) {
        this.f_19804_.m_135381_(HOME_POS, (Object)position);
    }

    public BlockPos getHome() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    public Vec3 getHomeAsVec() {
        BlockPos home = this.getHome();
        return new Vec3((double)home.m_123341_(), (double)home.m_123342_(), (double)home.m_123343_());
    }

    public void m_146762_(int age) {
        int i = this.f_146733_;
        super.m_146762_(age);
        this.f_146733_ = age;
        if (!this.isMale() && !((Boolean)ConfigGamerules.easyBreeding.get()).booleanValue() && i > 0 && age <= 0) {
            this.breed();
        }
    }

    public ResourceLocation getTexture() {
        return EntityUtils.getSkinFromEntity(this);
    }

    public static int getEcoLevel(LivingEntity entity) {
        if (entity instanceof Player) {
            return Math.round(4.0f + entity.m_21223_() / 6.0f);
        }
        double attack = Math.max(entity.m_21204_().m_22171_(Attributes.f_22281_) ? entity.m_21051_(Attributes.f_22281_).m_22135_() : 1.0, 4.0);
        if (entity instanceof ComplexMob && ((ComplexMob)entity).herd != null) {
            return Math.round((float)Math.sqrt((double)entity.m_21223_() * attack) / 2.5f) + ((ComplexMob)entity).herd.creatureList.size();
        }
        return Math.round((float)Math.sqrt((double)entity.m_21223_() * attack) / 2.5f);
    }

    protected void setAngry(boolean isAngry) {
        this.f_19804_.m_135381_(IS_ANGRY, (Object)isAngry);
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(IS_ANGRY);
    }

    public void setCommandInt(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)(command % 3));
    }

    public int getCommandInt() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public boolean shouldDespawn() {
        return this instanceof ISpecies && this.getHome() != BlockPos.f_121853_;
    }

    public void m_6043_() {
        BlockEntity burrow;
        super.m_6043_();
        if (this.shouldDespawn() && !this.f_19853_.m_45914_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue()) && this instanceof ISpecies && this.getHome() != BlockPos.f_121853_ && (burrow = this.f_19853_.m_7702_(this.getHome())) instanceof CritterBurrowBlockEntity) {
            ((CritterBurrowBlockEntity)burrow).tryEnterBurrow((LivingEntity)this);
            burrow.m_6596_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getHome() != BlockPos.f_121853_) {
            compound.m_128405_("HomePosX", this.getHome().m_123341_());
            compound.m_128405_("HomePosY", this.getHome().m_123342_());
            compound.m_128405_("HomePosZ", this.getHome().m_123343_());
        }
        if (this.m_21824_()) {
            compound.m_128405_("Command", this.getCommandInt());
        }
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128405_("Skin", this.getSkin());
        compound.m_128350_("Size", this.getMobSize());
        compound.m_128405_("Gender", this.getGender());
        compound.m_128379_("isAngry", this.isAngry());
        compound.m_128405_("PeacefulTicks", this.huntingCooldown);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("HomePosX")) {
            int i = compound.m_128451_("HomePosX");
            int j = compound.m_128451_("HomePosY");
            int k = compound.m_128451_("HomePosZ");
            this.setHome(new BlockPos(i, j, k));
        }
        if (compound.m_128441_("OwnerUUID")) {
            this.setCommandInt(compound.m_128451_("Command"));
        }
        this.setVariant(compound.m_128451_("Variant"));
        this.setSkin(compound.m_128451_("Skin"));
        this.setMobSize(compound.m_128457_("Size"));
        this.setGender(compound.m_128451_("Gender"));
        this.setAngry(compound.m_128471_("isAngry"));
        this.huntingCooldown = compound.m_128451_("PeacefulTicks");
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason != MobSpawnType.DISPENSER && reason != MobSpawnType.BUCKET) {
            if (this instanceof ISpecies) {
                Holder optional = worldIn.m_204166_(new BlockPos(this.m_20182_()));
                int i = ((ISpecies)((Object)this)).setSpeciesByBiome((Holder<Biome>)optional, reason);
                this.setVariant(i);
                if (i == 99) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return null;
                }
            }
            this.setGender(this.f_19796_.nextInt(2));
            this.setRandomMobSize();
            if (TEXTURES_COMMON.containsKey(this.m_6095_().getRegistryName().m_135815_())) {
                this.chooseSkinForSpecies(this, (Boolean)ConfigGamerules.wildRareSkins.get());
            }
            if (this instanceof INeedsPostUpdate) {
                ((INeedsPostUpdate)((Object)this)).updateAttributes();
            }
            this.m_146762_(0);
        }
        if (this instanceof IPackEntity) {
            IPackEntity.initPack(this);
        }
        return spawnDataIn;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_()) {
            ItemStack itemstack = player.m_21120_(hand);
            if (player.m_7500_() && itemstack.m_41619_() && this instanceof IPackEntity && this.herd != null) {
                for (int i = 0; i < this.herd.creatureList.size(); ++i) {
                    ComplexMob creature = this.herd.creatureList.get(i);
                    creature.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 80, 0));
                }
            }
            if (this.m_21824_() && this.m_142480_() == player) {
                if (itemstack.m_41619_()) {
                    this.setCommandInt(this.getCommandInt() + 1);
                    player.m_6352_((Component)new TranslatableComponent("entity.untamedwilds.command." + this.getCommandInt()), Util.f_137441_);
                    if (this.getCommandInt() > 1) {
                        this.m_21573_().m_26573_();
                        this.setSitting(true);
                    } else if (this.getCommandInt() <= 1 && this.isSitting()) {
                        this.setSitting(false);
                    }
                } else {
                    EntityUtils.consumeItemStack(this, itemstack);
                }
            }
            return super.m_6071_(player, hand);
        }
        return InteractionResult.PASS;
    }
}

