/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.IPackEntity;

public class HerdEntity {
    private int maxHerdSize;
    private float radius = 8.0f;
    private boolean openToCombine = true;
    private ComplexMob leader;
    private final Random rand;
    public final List<ComplexMob> creatureList = new ArrayList<ComplexMob>();

    public HerdEntity(ComplexMob creature, int maxSize) {
        this.rand = new Random();
        this.maxHerdSize = maxSize;
        this.setLeader(creature);
    }

    public void setLeader(ComplexMob creature) {
        this.leader = creature;
        if (!this.containsCreature(this.leader)) {
            this.addCreature(this.leader);
        }
    }

    public void chooseRandomLeader() {
        this.setLeader(this.creatureList.get(this.rand.nextInt(this.creatureList.size())));
    }

    public ComplexMob getLeader() {
        return this.leader;
    }

    public void addCreature(ComplexMob creature) {
        if (!this.creatureList.contains((Object)creature)) {
            this.creatureList.add(creature);
        }
    }

    public boolean containsCreature(ComplexMob creature) {
        return this.creatureList.contains((Object)creature);
    }

    public void removeCreature(HerdEntity herd, ComplexMob creature) {
        herd.creatureList.remove((Object)creature);
        if (herd.creatureList.size() > 0 && herd.getLeader() == creature) {
            herd.chooseRandomLeader();
        }
        if (creature instanceof IPackEntity) {
            IPackEntity.initPack(creature);
        }
    }

    public void setMaxSize(int maxSchoolSize) {
        this.maxHerdSize = maxSchoolSize;
    }

    public int getMaxSize() {
        return this.maxHerdSize;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setOpenToCombine(boolean openToCombine) {
        this.openToCombine = openToCombine;
    }

    private boolean isOpenToCombine() {
        return this.openToCombine;
    }

    public void tick() {
        if (this.creatureList.size() == this.getMaxSize()) {
            this.setOpenToCombine(false);
        } else if (this.rand.nextInt(1800) == 0) {
            this.setOpenToCombine(!this.isOpenToCombine());
        }
        if (this.getLeader().f_19797_ % 10 == 0) {
            ArrayList<ComplexMob> toRemove = new ArrayList<ComplexMob>();
            if (this.isOpenToCombine()) {
                List list = this.getLeader().m_183503_().m_45976_(ComplexMob.class, this.getLeader().m_142469_().m_82377_(16.0, 12.0, 16.0));
                for (ComplexMob creature : list) {
                    if (this.containsCreature(creature) || creature.herd == null || !HerdEntity.canCombineHerds(this, creature.herd)) continue;
                    int netSize = this.creatureList.size() + creature.herd.creatureList.size();
                    if (creature.herd.isOpenToCombine() || !((Object)((Object)creature)).getClass().equals(((Object)((Object)this.getLeader())).getClass()) || netSize > this.getMaxSize() || netSize > creature.herd.getMaxSize()) continue;
                    HerdEntity.combineHerds(this, creature.herd);
                }
            }
            for (ComplexMob complexMob : this.creatureList) {
                ComplexMob creature = complexMob;
                if (creature.m_6084_() && creature.m_20280_((Entity)this.leader) <= 1024.0) {
                    if (creature == this.leader || !(creature.m_20280_((Entity)this.leader) <= (double)(this.radius * this.radius))) continue;
                    Vec3 vec = this.leader.m_20154_();
                    creature.m_21563_().m_24950_(creature.m_20185_() + vec.f_82479_, creature.m_20186_() + vec.f_82480_, creature.m_20189_() + vec.f_82481_, 6.0f, 85.0f);
                    continue;
                }
                toRemove.add(creature);
            }
            for (ComplexMob mob : toRemove) {
                this.removeCreature(this, mob);
            }
        }
    }

    static boolean canCombineHerds(HerdEntity thisPack, HerdEntity otherPack) {
        return thisPack.creatureList.size() + otherPack.creatureList.size() <= thisPack.getMaxSize();
    }

    public static void combineHerds(HerdEntity herd1, HerdEntity herd2) {
        if (herd2.creatureList.size() > herd1.creatureList.size()) {
            herd1.setLeader(herd2.getLeader());
        }
        if (herd2.getMaxSize() < herd1.getMaxSize()) {
            herd1.setMaxSize(herd2.getMaxSize());
        }
        if (herd2.getRadius() < herd1.getRadius()) {
            herd1.setRadius(herd2.getRadius());
        }
        herd1.creatureList.addAll(herd2.creatureList);
    }
}

