/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.target.HuntMobTarget;

public class HuntWeakerTarget<T extends LivingEntity>
extends HuntMobTarget<T> {
    private final int executionChance;

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, 1, checkSight, null);
    }

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, int chance, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super(creature, classTarget, checkSight, 200, false, targetSelector);
        this.executionChance = chance;
    }

    @Override
    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        Mob mob;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || entity.m_20160_() || predicate != null && !predicate.test(entity) || (double)(entity.m_21223_() / entity.m_21233_()) > 0.8) {
            return false;
        }
        if (ComplexMob.getEcoLevel(entity) < ComplexMob.getEcoLevel((LivingEntity)this.f_26135_) && this.f_26135_.getClass() == entity.getClass() && (mob = this.f_26135_) instanceof ComplexMob) {
            ComplexMob attacker = (ComplexMob)mob;
            if (entity instanceof ComplexMob) {
                ComplexMob defender = (ComplexMob)entity;
                if (attacker.getVariant() == defender.getVariant()) {
                    return false;
                }
            }
        }
        return this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    @Override
    public boolean m_8036_() {
        if (this.f_26135_.m_6162_() || this.f_26135_.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.f_26135_.m_142469_().m_82377_(this.m_7623_(), 12.0, this.m_7623_()), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.f_26137_ = (LivingEntity)list.get(0);
        return true;
    }
}

